package com.xdja.update;

import android.content.Context;

/**
 * Created by cxp on 2016/3/4.
 */
public class VersionUpdateErrorCode {

    public static final int ErrBaseNum = 2000;
    public static String ErrMsg = "";// 错误信息
    public static final int Error_None = 0; // 没有错误
    public static final int Error_Create_Local_Version_File_Failed = ErrBaseNum+1;
    public static final int Error_Parse_Local_Version_File_Failed = ErrBaseNum+2;
    public static final int Error_Parse_Version_Name_Failed = ErrBaseNum+3;
    public static final int Error_Update_Local_Version_File_Failed = ErrBaseNum+4;
    public static final int Error_Version_Update_ServerIp_Empty = ErrBaseNum+5;
    public static final int Error_Version_Update_ServerPort_Empty = ErrBaseNum+6;
    public static final int Error_Connect_Update_Server_Failed = ErrBaseNum+7;
    public static final int Error_Send_Update_Data_Failed = ErrBaseNum+8;
    public static final int Error_Receive_Update_Date_Time_Out = ErrBaseNum+9;
    public static final int Error_No_Upgrade_Version = ErrBaseNum+11;
    public static final int Error_Current_Client_No_Config_Msg = ErrBaseNum+12;
    public static final int Error_Query_Upgrade_Configuration_Failed = ErrBaseNum+13;
    public static final int Error_Upgrade_Configuration_File_Does_Not_Exist = ErrBaseNum+14;
    public static final int Error_Version_Update_Failed = ErrBaseNum+15;
    public static final int Error_Unable_To_Resolve_Upgrade_Confirmation_Message = ErrBaseNum+16;
    public static final int Error_Parse_Version_Update_Config_File_Failed = ErrBaseNum+17;
    public static final int Error_Parse_Temp_Version_Config_File_Failed = ErrBaseNum+18;
    public static final int Error_busy = ErrBaseNum+19;


    /**
     * 根据错误代码errCode返回对应错误信息
     *
     * @param errCode
     * @return
     */
    public static String GetErrMsg(Context context, int errCode) {

        switch (errCode) {
            case Error_None:
                ErrMsg = context.getResources().getString(R.string.no_error);
                break;
            case Error_Create_Local_Version_File_Failed:
                ErrMsg = context.getResources().getString(R.string.version_init_failed);
                break;
            case Error_Parse_Local_Version_File_Failed:
                ErrMsg = context.getResources().getString(R.string.analyze_version_info_failed);
                break;
            case Error_Parse_Version_Name_Failed:
                ErrMsg = context.getResources().getString(R.string.parse_version_name_failed);
                break;
            case Error_Update_Local_Version_File_Failed:
                ErrMsg = context.getResources().getString(R.string.update_local_version_info_file_fail);
                break;
            case Error_Version_Update_ServerIp_Empty:
                ErrMsg = context.getResources().getString(R.string.not_set_update_server_url);

                break;
            case Error_Version_Update_ServerPort_Empty:
                ErrMsg = context.getResources().getString(R.string.not_set_update_server_port);
                break;
            case Error_Connect_Update_Server_Failed:
                ErrMsg = context.getResources().getString(R.string.connect_update_server_fail);
                break;
            case Error_Send_Update_Data_Failed:
                ErrMsg = context.getResources().getString(R.string.send_version_data_fail);
                break;
            case Error_Receive_Update_Date_Time_Out:
                ErrMsg = context.getResources().getString(R.string.receive_update_confirm_info_out);
                break;
            case Error_Version_Update_Failed:
                ErrMsg = context.getResources().getString(R.string.update_fail);
                break;
            case Error_No_Upgrade_Version:
                ErrMsg = context.getResources().getString(R.string.you_soft_already_new_version);
                break;
            case Error_Current_Client_No_Config_Msg:
                ErrMsg = context.getResources().getString(R.string.local_no_have_deploy_info);
                break;
            case Error_Query_Upgrade_Configuration_Failed:
                ErrMsg = context.getResources().getString(R.string.query_update_set_fail);
                break;
            case Error_Upgrade_Configuration_File_Does_Not_Exist:
                ErrMsg = context.getResources().getString(R.string.update_deploy_file_not_exist);
                break;
            case Error_Unable_To_Resolve_Upgrade_Confirmation_Message:
                ErrMsg = context.getResources().getString(R.string.can_not_analy_update_confirm_info);
                break;
            case Error_Parse_Version_Update_Config_File_Failed:
                ErrMsg = context.getResources().getString(R.string.analy_update_deploy_update_info_fail);
                break;
            case Error_Parse_Temp_Version_Config_File_Failed:
                ErrMsg = context.getResources().getString(R.string.analy_temp_version_info_fail);
                break;
            case Error_busy:
                ErrMsg=context.getResources().getString(R.string.check_update_task_busy);
                break;
            default:
                ErrMsg = context.getResources().getString(R.string.unknown_error) + errCode;
                break;
        }
        return ErrMsg;
    }

}
