package com.xdja.update;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.update.model.VersionConfigParentNodeInfo;
import com.xdja.update.model.VersionConfigSubNodeInfo;
import com.xdja.update.model.VersionParentNodeInfo;
import com.xdja.update.model.VersionSubNodeInfo;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;


/**
 * Created by cxp on 2016/3/3.
 */
public class VersionUpdateManager {
    public static final String TAG = "VersionUpdateManager";
    private static VersionUpdateManager ourInstance = null;
    private Context context;
    private String fileDir;

    public VersionUpdateManager(Context context) {
        this.context = context;
        fileDir = context.getFilesDir().getAbsolutePath();
    }

    public static synchronized VersionUpdateManager getInstance(Context context) {
        if (ourInstance == null) {
            ourInstance = new VersionUpdateManager(context);
        }
        return ourInstance;
    }


    /**
     * 创建本地版本文件信息
     */
    public VersionUpdateResult createLocalVersionInfo(String filename) {

        VersionUpdateResult tempVersionUpdateResult = new VersionUpdateResult();

        if (!(new File(filename).exists())) {

            InputStream in;
            FileOutputStream out;

            try {
                in = context.getResources().getAssets().open("ClientVer.xml");
                out = context.openFileOutput("ClientVer.xml", Context.MODE_PRIVATE);

                byte[] buffer = new byte[8192];
                int count;
                // 开始复制文件
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                    out.flush();
                }
                in.close();
                out.close();
            } catch (Exception ioe) {
                ioe.printStackTrace();
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Create_Local_Version_File_Failed);
            }
        }
        return tempVersionUpdateResult;
    }

    /*
     * 解析版本信息
	 */
    public VersionUpdateResult parseLocalVersionInfo(String filename) {

        VersionUpdateResult tempVersionUpdateResult = new VersionUpdateResult();
        VersionParentNodeInfo versionParentNodeInfo = new VersionParentNodeInfo();
        ArrayList<VersionSubNodeInfo> tempArrayList = new ArrayList<>();

//        verList.clear(); // 在未配置升级信息强进入升级程序会有数据，故清空数据。
        DocumentBuilderFactory docBuilderFactory;
        DocumentBuilder docBuilder;
        Document doc;
        FileInputStream in = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            in = new FileInputStream(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setServerIp(nodeList.item(0).getFirstChild().getNodeValue());// 取升级服务器IP
            }

            nodeList = root.getElementsByTagName("ServerPort");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setServerPort(nodeList.item(0).getFirstChild().getNodeValue());// 取升级服务器Port
            }

            nodeList = root.getElementsByTagName("Factory");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setFactory(nodeList.item(0).getFirstChild().getNodeValue());// 取手机厂商
            }

            nodeList = root.getElementsByTagName("Mod");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setPhoneModel(nodeList.item(0).getFirstChild().getNodeValue());// 取手机型号
            }

            nodeList = root.getElementsByTagName("OS");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setAndroidOS(nodeList.item(0).getFirstChild().getNodeValue());// 取手机系统
            }

            nodeList = root.getElementsByTagName("Soft");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setAppName(nodeList.item(0).getFirstChild().getNodeValue());// 取升级软件名称
            }

            nodeList = root.getElementsByTagName("UserName");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionParentNodeInfo.setUserName(nodeList.item(0).getFirstChild().getNodeValue());// 取用户名
            }

            nodeList = root.getElementsByTagName("Ver");// 取升级版本历史信息
            int nodeNum = nodeList.getLength();

            Element childElement;
            NodeList childList;

            for (int i = 0; i < nodeNum; i++) {
                VersionSubNodeInfo versionSubNodeInfo = new VersionSubNodeInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    versionSubNodeInfo.setVersion(childList.item(0).getFirstChild().getNodeValue());// 取版本信息
                }
                childList = childElement.getElementsByTagName("Date");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    versionSubNodeInfo.setDate(childList.item(0).getFirstChild().getNodeValue());// 取版本日期
                }
                childList = childElement.getElementsByTagName("Note");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    versionSubNodeInfo.setNote(childList.item(0).getFirstChild().getNodeValue());// 取版本备注信息
                }
                tempArrayList.add(versionSubNodeInfo);// 添加版本信息到链表中
            }

            versionParentNodeInfo.setVersionSubNodeInfos(tempArrayList);

        } catch (Exception ex) {
            ex.printStackTrace();
            tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Parse_Local_Version_File_Failed);
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            tempVersionUpdateResult.setData(versionParentNodeInfo);
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return tempVersionUpdateResult;
    }

    /**
     * 更新本地版本文件
     *
     * @param verName
     * @param versionParentNodeInfo
     */
    public VersionUpdateResult updateVersionXmlFile(String verName, VersionParentNodeInfo versionParentNodeInfo) {

        VersionUpdateResult writeVersionFileResult = new VersionUpdateResult();

        VersionParentNodeInfo tempVersionParentNodeInfo = versionParentNodeInfo;

        ArrayList<VersionSubNodeInfo> versionSubNodeInfos = tempVersionParentNodeInfo.getVersionSubNodeInfos();

        if (versionSubNodeInfos.size() > 0) {

            VersionSubNodeInfo versionSubNodeInfo = versionSubNodeInfos.get((versionSubNodeInfos.size() - 1));

            if ((!verName.equals(versionSubNodeInfo.getVersion())) && (versionSubNodeInfos.size() > 1)) {

                versionSubNodeInfos.remove(versionSubNodeInfos.size() - 1);

                VersionUpdateResult tempWriteVersionFileResult = reWriteVersionInfo(fileDir + "/ClientVer.xml", tempVersionParentNodeInfo);
                writeVersionFileResult.setResultCode(tempWriteVersionFileResult.getResultCode());
                writeVersionFileResult.setData(tempWriteVersionFileResult.getData());

            }
        }
        return writeVersionFileResult;
    }

    /**
     * 重写版本信息
     */
    public VersionUpdateResult reWriteVersionInfo(String filename, VersionParentNodeInfo versionParentNodeInfo) {

        VersionParentNodeInfo tempVersionParentNodeInfo = versionParentNodeInfo;

        ArrayList<VersionSubNodeInfo> versionSubNodeInfos = tempVersionParentNodeInfo.getVersionSubNodeInfos();


        StringBuilder verstr = new StringBuilder();
        verstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verstr.append("<Root>");

        verstr.append("<ServerIP>");
        verstr.append(versionParentNodeInfo.getServerIp());
        verstr.append("</ServerIP>");

        verstr.append("<ServerPort>");
        verstr.append(versionParentNodeInfo.getServerPort());
        verstr.append("</ServerPort>");

        verstr.append("<Factory>");
        verstr.append(versionParentNodeInfo.getFactory());
        verstr.append("</Factory>");

        verstr.append("<Mod>");
        verstr.append(versionParentNodeInfo.getPhoneModel());
        verstr.append("</Mod>");

        verstr.append("<OS>");
        verstr.append(versionParentNodeInfo.getAndroidOS());
        verstr.append("</OS>");

        verstr.append("<Soft>");
        verstr.append(versionParentNodeInfo.getAppName());
        verstr.append("</Soft>");

        verstr.append("<UserName>");
        verstr.append(versionParentNodeInfo.getUserName());
        verstr.append("</UserName>");


        int verListNum = versionSubNodeInfos.size();
        VersionSubNodeInfo vi;
        for (int i = 0; i < verListNum; i++) {// 版本升级历史信息
            vi = versionSubNodeInfos.get(i);
            verstr.append("<Ver>");

            verstr.append("<Version>");
            verstr.append(vi.getVersion());
            verstr.append("</Version>");

            verstr.append("<Date>");
            verstr.append(vi.getDate());
            verstr.append("</Date>");

            verstr.append("<Note>");
            verstr.append(vi.getNote());
            verstr.append("</Note>");

            verstr.append("</Ver>");
        }

        verstr.append("</Root>");

        VersionUpdateResult writeFileResult = writeFile(filename, verstr.toString(), false);// 初始化客户端版本信息

        return writeFileResult;
    }

    /*
     *写文件
     */
    public VersionUpdateResult writeFile(String filename, String data, boolean append) {

        VersionUpdateResult tempVersionUpdateResult = new VersionUpdateResult();

        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename, append);
            if (out != null) {
                out.write(data.getBytes());
                out.flush();
            }

        } catch (IOException e) {
            e.printStackTrace();
            tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Update_Local_Version_File_Failed);
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Update_Local_Version_File_Failed);
            }
        }
        return tempVersionUpdateResult;
    }


    /**
     * 获取检查版本的XML
     *
     * @param verName
     * @param versionParentNodeInfo
     * @return
     */
    @NonNull
    public StringBuffer getCheckUpdateXmlStr(String deviceId,String verName, VersionParentNodeInfo versionParentNodeInfo) {
        //todo 添加TFCardUtils类
//        TFCardUtils tfCardUtils = ((SmailApplication) context.getApplicationContext()).getAppComponent().tfCardUtils();
        VersionParentNodeInfo tempVersionParentNodeInfo = versionParentNodeInfo;

        StringBuffer checkVer = new StringBuffer();
        checkVer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        checkVer.append("<Root>");

        checkVer.append("<Req>checkver</Req>");
        checkVer.append("<Factory>");
        checkVer.append(tempVersionParentNodeInfo.getFactory());
        checkVer.append("</Factory>");

        checkVer.append("<Mod>");
        checkVer.append(tempVersionParentNodeInfo.getPhoneModel());
        checkVer.append("</Mod>");

        checkVer.append("<OS>");
        checkVer.append(tempVersionParentNodeInfo.getAndroidOS());
        checkVer.append("</OS>");

        checkVer.append("<Soft>");
        checkVer.append(tempVersionParentNodeInfo.getAppName());
        checkVer.append("</Soft>");

        checkVer.append("<Version>");
        checkVer.append(verName);
        checkVer.append("</Version>");

        checkVer.append("<UserName>");
        checkVer.append(tempVersionParentNodeInfo.getUserName());
        checkVer.append("</UserName>");
        //todo 获取tfcardid
//        String deviceId = "78646a6178646a61325256333911627a";
//        String deviceId = "";
        //cxp add 2016-10-12 配置灰度发布卡号为空：解决发布灰度升级时，无卡设备可以检测到的BUG
        if (TextUtils.isEmpty(deviceId)) {
            deviceId = "";
        }
        checkVer.append("<CardNo>" + deviceId + "</CardNo>");
        checkVer.append("</Root>");
        return checkVer;
    }

    /*
     * 解析版本升级确认信息
	 */
    public int parseVersionUpdateReceiveData(byte[] confirmInfo) {
        DocumentBuilderFactory docBuilderFactory;
        DocumentBuilder docBuilder;
        Document doc;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo);
            doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Result");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();// 取版本升级确认信息
                return Integer.parseInt(result);
            } else {
                return -1;
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /**
     * 解析检查更新返回结果
     * <p><b>该方法的返回方式是之前实现方式，在返回值设计上不合理，暂时不修改</b></p>
     *
     * @param resourceCode 返回结果代码
     * @return 解析结果：如果有错误，则返回错误内容；如果没有错误，则返回null
     */
    @Nullable
    public VersionUpdateResult parseCheckUpdateRes(UpdateSocket sl, int resourceCode) {

        VersionUpdateResult tempVersionUpdateResult = new VersionUpdateResult();
        byte[] result;
        switch (resourceCode) {
            case 0:
                result = sl.recvData();
                if (result == null) {
                    tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Receive_Update_Date_Time_Out);
                    Log.d(TAG, "VersionUpdateManager: parseCheckUpdateRes :sl.recvData: result is :--->" + result);
                    return tempVersionUpdateResult;
                } else {
                    // 解决断点续传停止后，跨版本无法升级问题
                    new File(fileDir + "/update_temp.xml").delete();
                    if (new File(fileDir + "/update_s.xml").exists()) {
                        UpdateFunc.WriteFile(fileDir + "/update_temp.xml", result, false);
                    } else {
                        UpdateFunc.WriteFile(fileDir + "/update_s.xml", result, false);// 把升级配置信息写入本地文件update_s.xml
                    }
                }
                break;
            case 1:
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_No_Upgrade_Version);
                break;
            case 2:
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Current_Client_No_Config_Msg);
                break;
            case 3:
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Query_Upgrade_Configuration_Failed);
                break;
            case 4:
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Upgrade_Configuration_File_Does_Not_Exist);
                break;
            case -1:
                tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Unable_To_Resolve_Upgrade_Confirmation_Message);
                break;
        }

        return tempVersionUpdateResult;
    }


    /*
     * 解析版本升级配置信息
	 */
    public VersionUpdateResult parseConfigInfo(String filename) {


        VersionUpdateResult tempVersionUpdateResult = new VersionUpdateResult();
        VersionConfigParentNodeInfo versionConfigParentNodeInfo = new VersionConfigParentNodeInfo();
        ArrayList<VersionConfigSubNodeInfo> tempArrayList = new ArrayList<>();

        DocumentBuilderFactory docBuilderFactory;
        DocumentBuilder docBuilder;
        Document doc;
        boolean res = false;
        FileInputStream in = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            in = new FileInputStream(fileDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Version");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionConfigParentNodeInfo.setVersion(nodeList.item(0).getFirstChild().getNodeValue());// 取升级版本号
            }

            nodeList = root.getElementsByTagName("DeleteDb");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionConfigParentNodeInfo.setDeleteDb(nodeList.item(0).getFirstChild().getNodeValue());//是否删除数据库 0 不删除，1删除
            }

            nodeList = root.getElementsByTagName("CheckCode");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionConfigParentNodeInfo.setCheckCode(nodeList.item(0).getFirstChild().getNodeValue());// 版本内容校验码
            }

            nodeList = root.getElementsByTagName("Date");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionConfigParentNodeInfo.setDate(nodeList.item(0).getFirstChild().getNodeValue());// 取升级版本发布时间
            }

            nodeList = root.getElementsByTagName("Comment");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionConfigParentNodeInfo.setComment(nodeList.item(0).getFirstChild().getNodeValue());// 取升级版本注释信息
            }

            nodeList = root.getElementsByTagName("UpdateTag");
            if (!TextUtils.isEmpty(nodeList.item(0).getFirstChild().toString())) {
                versionConfigParentNodeInfo.setUpdateTag(nodeList.item(0).getFirstChild().getNodeValue());// 取升级版本更新类型
            }

            nodeList = root.getElementsByTagName("File");// 取升级版本文件列表
            int nodeNum = nodeList.getLength();

            Element childElement;
            NodeList childList;
            for (int i = 0; i < nodeNum; i++) {
                VersionConfigSubNodeInfo subNodeInfo = new VersionConfigSubNodeInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("RPath");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setRpath(childList.item(0).getFirstChild().getNodeValue());// 远程文件所在路径
                }

                childList = childElement.getElementsByTagName("LPath");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setLpath(childList.item(0).getFirstChild().getNodeValue());// 本地文件所在路径
                }

                childList = childElement.getElementsByTagName("FName");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setFilename(childList.item(0).getFirstChild().getNodeValue());// 文件名
                }

                childList = childElement.getElementsByTagName("FSize");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setFilesize(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));// 文件大小
                }

                childList = childElement.getElementsByTagName("Action");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setAction(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));// 动作类型
                }

                childList = childElement.getElementsByTagName("State");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setState(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));// 当前状态
                }

                childList = childElement.getElementsByTagName("CSize");
                if (!TextUtils.isEmpty(childList.item(0).getFirstChild().toString())) {
                    subNodeInfo.setCsize(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));// 当前已经下载大小
                }
                tempArrayList.add(subNodeInfo);// 添加文件信息到链表中
            }

        } catch (Exception ex) {
            ex.printStackTrace();
            Log.e(TAG, "VersionUpdateManager:---parseConfigInfo:--->", ex);
            tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Parse_Version_Update_Config_File_Failed);
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
            versionConfigParentNodeInfo.setVersionConfigSubNodeInfos(tempArrayList);
            tempVersionUpdateResult.setData(versionConfigParentNodeInfo);
        }
        return tempVersionUpdateResult;

    }


    /*
     * 解析版本临时配置信息
	 */
    public VersionUpdateResult parseTempInfo(String filename) {

        VersionUpdateResult tempVersionUpdateResult = new VersionUpdateResult();
        String tempVersion = "";

        DocumentBuilderFactory docBuilderFactory;
        DocumentBuilder docBuilder;
        Document doc;
        boolean res = false;
        FileInputStream in = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            in = new FileInputStream(fileDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                tempVersion = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本号
            }

            res = true;

        } catch (Exception ex) {
            tempVersionUpdateResult.setResultCode(VersionUpdateErrorCode.Error_Parse_Temp_Version_Config_File_Failed);
            Log.e(TAG, "解析临时版本配置信息失败:", ex);
            ex.printStackTrace();

        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
            tempVersionUpdateResult.setData(tempVersion);
        }
        return tempVersionUpdateResult;

    }


    /**
     * 重写版本升级配置信息
     */
    public void reWriteConfigInfo(String filename, VersionConfigParentNodeInfo versionConfigParentNodeInfo) {

        VersionConfigParentNodeInfo tempVersionConfigParentNodeInfo = versionConfigParentNodeInfo;

        StringBuilder getfile = new StringBuilder();
        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        getfile.append("<Root>");

        getfile.append("<Version>");
        getfile.append(tempVersionConfigParentNodeInfo.getVersion());
        getfile.append("</Version>");

        getfile.append("<Date>");
        getfile.append(tempVersionConfigParentNodeInfo.getDate());
        getfile.append("</Date>");

        getfile.append("<Comment>");
        getfile.append(tempVersionConfigParentNodeInfo.getComment());
        getfile.append("</Comment>");

        getfile.append("<UpdateTag>");
        getfile.append(tempVersionConfigParentNodeInfo.getUpdateTag());
        getfile.append("</UpdateTag>");

        getfile.append("<DeleteDb>");
        getfile.append(tempVersionConfigParentNodeInfo.getDeleteDb());
        getfile.append("</DeleteDb>");

        getfile.append("<CheckCode>");
        getfile.append(tempVersionConfigParentNodeInfo.getCheckCode());
        getfile.append("</CheckCode>");


        getfile.append("<Files>");

        ArrayList<VersionConfigSubNodeInfo> versionConfigSubNodeInfos = tempVersionConfigParentNodeInfo.getVersionConfigSubNodeInfos();
        if (versionConfigSubNodeInfos != null) {
            int fileListNum = versionConfigSubNodeInfos.size();
            VersionConfigSubNodeInfo fi;
            for (int i = 0; i < fileListNum; i++) {// 文件列表
                fi = versionConfigSubNodeInfos.get(i);
                getfile.append("<File>");

                getfile.append("<RPath>");
                getfile.append(fi.getRpath());
                getfile.append("</RPath>");

                getfile.append("<LPath>");
                getfile.append(fi.getLpath());
                getfile.append("</LPath>");

                getfile.append("<FName>");
                getfile.append(fi.getFilename());
                getfile.append("</FName>");

                getfile.append("<FSize>");
                getfile.append(fi.getFilesize());
                getfile.append("</FSize>");

                getfile.append("<Action>");
                getfile.append(fi.getAction());
                getfile.append("</Action>");

                getfile.append("<State>");
                getfile.append(fi.getState());
                getfile.append("</State>");

                getfile.append("<CSize>");
                getfile.append(fi.getCsize());
                getfile.append("</CSize>");

                getfile.append("</File>");
            }
        }


        getfile.append("</Files>");
        getfile.append("</Root>");

        UpdateFunc.WriteFile(filename, getfile.toString(), false);// 重写版本升级配置信息
    }

    public String getHash(String fileName, String hashType) {

        InputStream fis = null;
        MessageDigest md5 = null;
        try {
            fis = new FileInputStream(fileName);//读取文件

            byte[] buffer = new byte[1024];
            md5 = MessageDigest.getInstance(hashType);
            int numRead = 0;
            while ((numRead = fis.read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
        } catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        byte[] digest = md5.digest();
        if (digest != null && digest.length > 0) {
            return toHexString(digest);
        }
        return "";
    }

    public String toHexString(byte[] data) {
        if (data != null && data.length > 0) {
            StringBuilder sb = new StringBuilder(data.length * 2);
            for (int i = 0; i < data.length; i++) {
                sb.append(hexChar[(data[i] & 0xf0) >>> 4]);
                sb.append(hexChar[data[i] & 0x0f]);
            }
            return sb.toString();
        }
        return "";
    }

    public char[] hexChar = {'0', '1', '2', '3', '4', '5', '6', '7',
            '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};


    @NonNull
    public StringBuffer getReqUpdateFileContentXml(VersionConfigSubNodeInfo fi) {
        StringBuffer getfile = new StringBuffer();
        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        getfile.append("<Root>");

        getfile.append("<Req>getfile</Req>");
        getfile.append("<RPath>");
        getfile.append(fi.getRpath());
        getfile.append("</RPath>");

        getfile.append("<LPath>");
        getfile.append(fi.getLpath());
        getfile.append("</LPath>");

        getfile.append("<FName>");
        getfile.append(fi.getFilename());
        getfile.append("</FName>");

        getfile.append("<FSize>");
        getfile.append(fi.getFilesize());
        getfile.append("</FSize>");

        getfile.append("<FPos>");
        getfile.append(fi.getCsize());
        getfile.append("</FPos>");

        getfile.append("</Root>");
        return getfile;
    }

    /*
     * 解析版本升级确认信息
	 */
    public int parseConfirmInfo(byte[] confirmInfo) {
        if (confirmInfo != null) {
            DocumentBuilderFactory docBuilderFactory;
            DocumentBuilder docBuilder;
            Document doc;
            try {
                docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilder = docBuilderFactory.newDocumentBuilder();
                ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo);
                doc = docBuilder.parse(stream);
                Element root = doc.getDocumentElement();

                NodeList nodeList = root.getElementsByTagName("Result");
                if (nodeList.item(0).getFirstChild() != null) {
                    String result = nodeList.item(0).getFirstChild().getNodeValue();// 取版本升级确认信息
                    return Integer.parseInt(result);
                } else {
                    return -1;
                }
            } catch (Exception ex) {
                ex.printStackTrace();
                return -1;
            } finally {
                doc = null;
                docBuilder = null;
                docBuilderFactory = null;
            }
        }
        return 0;
    }


}
