package com.xdja.update;

import android.content.Context;
import android.text.TextUtils;

import com.xdja.update.model.VersionConfigParentNodeInfo;


/**
 * Created by cxp on 2016/3/4.
 */
public class VersionUpdateResult<T> {

    /**
     * 成功
     */
    public static final int CODE_OK = 0;

    /**
     * 返回代码 成功返回 0
     */
    private int resultCode = CODE_OK;

    /**
     * 错误时返回错误代码对应错误信息，成功时返回成功提示
     */

    private String message;

    /**
     * 返回数据
     */
    private T data;

    private Object tag;
    private VersionConfigParentNodeInfo versionConfigParentNodeInfo;

    public int getResultCode() {
        return resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public String getMessage(Context context) {
        if (TextUtils.isEmpty(message)) {
            return VersionUpdateErrorCode.GetErrMsg(context, resultCode);
        }
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Object getTag() {
        return tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    /**
     * 返回结果是否有错误
     *
     * @return
     * @作者 蔡晓鹏
     * @since 2014年10月13日 上午11:40:20
     */
    public boolean isError() {
        return resultCode != CODE_OK;
    }

    public VersionConfigParentNodeInfo getVersionConfigParentNodeInfo() {
        return versionConfigParentNodeInfo;
    }

    public void setVersionConfigParentNodeInfo(VersionConfigParentNodeInfo versionConfigParentNodeInfo) {
        this.versionConfigParentNodeInfo = versionConfigParentNodeInfo;
    }
}
