package com.xdja.update.bean;

import android.support.annotation.StringDef;

import com.xdja.update.enums.CheckUpdateError;

import java.io.Serializable;
import java.util.List;

/**
 * <b>Description: 检测更新结果</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/10/19 11:41.
 */
public class CheckResult implements Serializable {
    /**
     * The constant UPDATE_REQ_DEFAULT.
     */
    public static final String UPDATE_REQ_DEFAULT = "checkver";

    /**
     * 请求类别
     */
    private String req = UPDATE_REQ_DEFAULT;
    /**
     * 检测更新结果。参考{@link #RESULT_UPDATE_ERROR}/{@link #RESULT_UPDATE_NEGATIVE/{@link #RESULT_UPDATE_POSITIVE}}
     */
    @UpdateTag
    private String result;
    /**
     * 检测结果详细描述（格式为：[插件类型|版本号|插件名#插件类型|版本号|插件名]]）
     */
    private String modPower;
    /**
     * 检测附加信息
     */
    private String msg;
    /**
     * 更新列表
     */
    private List<Update> updates;
    /**
     * 检测升级错误原因及描述
     */
    private CheckUpdateError checkUpdateError;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder()
                .append("<Root>")
                .append("<Req>").append(req).append("</Req>")
                .append("<Result>").append(result).append("</Result>")
                .append("<ModPower>").append(modPower).append("</ModPower>")
                .append("<Msg>").append(msg).append("</Msg>")
                .append("<Updates>");
        if (updates != null && !updates.isEmpty()) {
            for (Update update : updates) {
                sb.append(update.toString());
            }
        }
        sb.append("</Updates>").append("</Root>");
        return sb.toString();
    }

    /**
     * Gets updates.
     *
     * @return {@link #updates}
     */
    public List<Update> getUpdates() {
        return updates;
    }

    /**
     * Sets updates.
     *
     * @param updates {@link #updates}
     */
    public void setUpdates(List<Update> updates) {
        this.updates = updates;
    }

    /**
     * Gets req.
     *
     * @return {@link #req}
     */
    public String getReq() {
        return req;
    }

    /**
     * Sets req.
     *
     * @param req {@link #req}
     */
    public void setReq(String req) {
        this.req = req;
    }

    /**
     * Gets result.
     *
     * @return {@link #result}
     */
    @UpdateTag
    public String getResult() {
        return result;
    }

    /**
     * Sets result.
     *
     * @param result {@link #result}
     */
    public void setResult(@UpdateTag String result) {
        this.result = result;
    }

    /**
     * Gets mod power.
     *
     * @return {@link #modPower}
     */
    public String getModPower() {
        return modPower;
    }

    /**
     * Sets mod power.
     *
     * @param modPowser {@link #modPower}
     */
    public void setModPower(String modPowser) {
        this.modPower = modPowser;
    }

    /**
     * Gets msg.
     *
     * @return {@link #msg}
     */
    public String getMsg() {
        return msg;
    }

    /**
     * Sets msg.
     *
     * @param msg {@link #msg}
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * 获取检测升级错误原因
     *
     * @return
     */
    public CheckUpdateError getCheckUpdateError() {
        return checkUpdateError;
    }

    /**
     * set 检测升级失败原因
     *
     * @param checkUpdateError
     */
    public void setCheckUpdateError(CheckUpdateError checkUpdateError) {
        this.checkUpdateError = checkUpdateError;
    }

    /**
     * 升级更新类
     */
    public static class Update implements Serializable {
        /**
         * 版本类型（包名）
         */
        private String verType;
        /**
         * 版本号
         */
        private String version;
        /**
         * 发布日期
         */
        private String date;
        /**
         * 备注信息
         */
        private String comment;
        /**
         * 更新标识（0提醒升级，1强制升级）
         */
        private int updateTag;
        /**
         * 该更新相关的文件列表
         */
        private List<File> files;

        /**
         * Gets ver type.
         *
         * @return {@link #verType}
         */
        public String getVerType() {
            return verType;
        }

        /**
         * Sets ver type.
         *
         * @param verType {@link #verType}
         */
        public void setVerType(String verType) {
            this.verType = verType;
        }

        /**
         * Gets version.
         *
         * @return {@link #verType}
         */
        public String getVersion() {
            return version;
        }

        /**
         * Sets version.
         *
         * @param version {@link #version}
         */
        public void setVersion(String version) {
            this.version = version;
        }

        /**
         * Gets date.
         *
         * @return {@link #date}
         */
        public String getDate() {
            return date;
        }

        /**
         * Sets date.
         *
         * @param date {@link #date}
         */
        public void setDate(String date) {
            this.date = date;
        }

        /**
         * Gets comment.
         *
         * @return {@link #comment}
         */
        public String getComment() {
            return comment;
        }

        /**
         * Sets comment.
         *
         * @param comment {@link #comment}
         */
        public void setComment(String comment) {
            this.comment = comment;
        }

        /**
         * Gets update tag.
         *
         * @return {@link #updateTag}
         */
        public int getUpdateTag() {
            return updateTag;
        }

        /**
         * Sets update tag.
         *
         * @param updateTag {@link #updateTag}
         */
        public void setUpdateTag(int updateTag) {
            this.updateTag = updateTag;
        }

        /**
         * Gets files.
         *
         * @return {@link #files}
         */
        public List<File> getFiles() {
            return files;
        }

        /**
         * Sets files.
         *
         * @param files {@link #files}
         */
        public void setFiles(List<File> files) {
            this.files = files;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("<Update>")
                    .append("<VerType>").append(verType).append("</VerType>")
                    .append("<Version>").append(version).append("</Version>")
                    .append("<Date>").append(date).append("</Date>")
                    .append("<Comment>").append(comment).append("</Comment>")
                    .append("<UpdateTag>").append(updateTag).append("</UpdateTag>")
                    .append("<Files>");
            if (files != null && !files.isEmpty()) {
                for (File file : files) {
                    builder.append(file.toString());
                }
            }
            builder.append("</Files>").append("</Update>");
            return builder.toString();
        }

        /**
         * 升级文件类
         */
        public static class File implements Serializable {
            /**
             * 升级文件所在路径，相对路径
             */
            private String rPath;
            /**
             * 安装路径
             */
            private String lPath;
            /**
             * 文件名
             */
            private String fName;
            /**
             * 文件总大小
             */
            private long fSize;
            /**
             * 执行动作（0 执行|1添加|2 替换|3 删除）
             */
            private int action;
            /**
             * 状态（0未处理 1正在处理 2已经处理）
             */
            private int state;
            /**
             * 已下载文件大小
             */
            private long cSize;
            /**
             * 文件校验码
             */
            private String checkCode;
            /**
             * 数据库删除标示[0 不删除数据库 1 删除数据库]
             */
            private int deleteDb;
            /**
             * 文件ID
             */
            private String fileId;

            /**
             * Gets path.
             *
             * @return {@link #rPath}
             */
            public String getrPath() {
                return rPath;
            }

            /**
             * Sets path.
             *
             * @param rPath {@link #rPath}
             */
            public void setrPath(String rPath) {
                this.rPath = rPath;
            }

            /**
             * Gets path.
             *
             * @return {@link #lPath}
             */
            public String getlPath() {
                return lPath;
            }

            /**
             * Sets path.
             *
             * @param lPath {@link #lPath}
             */
            public void setlPath(String lPath) {
                this.lPath = lPath;
            }

            /**
             * Gets name.
             *
             * @return {@link #fName}
             */
            public String getfName() {
                return fName;
            }

            /**
             * Sets name.
             *
             * @param fName {@link #fName}
             */
            public void setfName(String fName) {
                this.fName = fName;
            }

            /**
             * Gets size.
             *
             * @return {@link #fSize}
             */
            public long getfSize() {
                return fSize;
            }

            /**
             * Sets size.
             *
             * @param fSize {@link #fSize}
             */
            public void setfSize(long fSize) {
                this.fSize = fSize;
            }

            /**
             * Gets action.
             *
             * @return {@link #action}
             */
            public int getAction() {
                return action;
            }

            /**
             * Sets action.
             *
             * @param action {@link #action}
             */
            public void setAction(int action) {
                this.action = action;
            }

            /**
             * Gets state.
             *
             * @return {@link #state}
             */
            public int getState() {
                return state;
            }

            /**
             * Sets state.
             *
             * @param state {@link #state}
             */
            public void setState(int state) {
                this.state = state;
            }

            /**
             * Gets size.
             *
             * @return {@link #cSize}
             */
            public long getcSize() {
                return cSize;
            }

            /**
             * Sets size.
             *
             * @param cSize {@link #cSize}
             */
            public void setcSize(long cSize) {
                this.cSize = cSize;
            }

            /**
             * Gets check code.
             *
             * @return {@link #checkCode}
             */
            public String getCheckCode() {
                return checkCode;
            }

            /**
             * Sets check code.
             *
             * @param checkCode {@link #checkCode}
             */
            public void setCheckCode(String checkCode) {
                this.checkCode = checkCode;
            }

            /**
             * Gets delete db.
             *
             * @return {@link #deleteDb}
             */
            public int getDeleteDb() {
                return deleteDb;
            }

            /**
             * Sets delete db.
             *
             * @param deleteDb {@link #deleteDb}
             */
            public void setDeleteDb(int deleteDb) {
                this.deleteDb = deleteDb;
            }

            /**
             * Gets file id.
             *
             * @return {@link #fileId}
             */
            public String getFileId() {
                return fileId;
            }

            /**
             * Sets file id.
             *
             * @param fileId {@link #fileId}
             */
            public void setFileId(String fileId) {
                this.fileId = fileId;
            }

            @Override
            public String toString() {
                //noinspection StringBufferReplaceableByString
                return new StringBuilder()
                        .append("<File>")
                        .append("<RPath>").append(rPath).append("/RPath")
                        .append("<LPath>").append(lPath).append("</LPath>")
                        .append("<FName>").append(fName).append("</FName>")
                        .append("<FSize>").append(fSize).append("</FSize>")
                        .append("<Action>").append(action).append("</Action>")
                        .append("<State>").append(state).append("</State>")
                        .append("<CSize>").append(cSize).append("</CSize>")
                        .append("<CheckCode>").append(checkCode).append("</CheckCode>")
                        .append("<DeleteDb>").append(deleteDb).append("</DeleteDb>")
                        .append("<FileId>").append(fileId).append("</FileId>")
                        .append("</File>").toString();
            }
        }
    }

    /**
     * The interface Update tag.
     */
    @StringDef({RESULT_UPDATE_ERROR, RESULT_UPDATE_NEGATIVE, RESULT_UPDATE_POSITIVE})
    public @interface UpdateTag {
    }

    /**
     * 检测更新失败
     */
    public static final String RESULT_UPDATE_ERROR = "-1";
    /**
     * 无更新
     */
    public static final String RESULT_UPDATE_NEGATIVE = "1";
    /**
     * 有更新
     */
    public static final String RESULT_UPDATE_POSITIVE = "0";
}
