package com.xdja.update.enums;

public enum CheckUpdateError {


    CHECK_UNKNOW_ERROR(0, "未知错误"),

    CHECK_CONFIG_ERROR(1, "本地配置文件有错"),

    CHECK_UPDATE_ERROR(2, "请求升级失败"),

    CHECK_SERVER_ERROR(3, "升级服务器响应数据有误"),

    CHECK_DATA_ERROR(4, "解析升级数据失败"),

    CHECK_REQUEST_PARAMETER_ERROR(5, "请求参数有误");

    private int key = -1;
    private String describe = "";

    CheckUpdateError(int key, String describe) {
        this.key = key;
        this.describe = describe;
    }

    public static CheckUpdateError getCheckUpdateError(int key) {
        CheckUpdateError checkResult = CHECK_UNKNOW_ERROR;

        for (CheckUpdateError type : CheckUpdateError.values()) {
            if (type.getKey() == key) {
                checkResult = type;
                break;
            }
        }

        return checkResult;
    }

    public int getKey() {
        return key;
    }

    public String getDescribe() {
        return describe;
    }
}
