package com.xdja.update.enums;

public enum DownLoadFileError {

    DOWNLOAD_DEFAULT(0, "下载升级文件失败"),

    DOWNLOAD_NULL_FIELD_ID(1, "fieldid为空"),

    DOWNLOAD_TIME_OUT(2, "下载过程中网络超时"),

    DOWNLOAD_SERVER_RESPONSE_ERROR(3, "服务器响应错误"),

    DOWNLOAD_HASHCODE_ERROR(4, "文件校验失败"),

    DOWNLOAD_STORGE_PERMISSION_ERROR(5, "创建下载文件目录出错，下载路径不合法或未获取存储卡权限");




    private int key = -1;
    private String describe = "";

    DownLoadFileError(int key, String describe) {
        this.key = key;
        this.describe = describe;
    }

    public static DownLoadFileError getDownLoadFileResult(int key) {
        DownLoadFileError downLoadFileResult = DOWNLOAD_DEFAULT;

        for (DownLoadFileError type : DownLoadFileError.values()) {
            if (type.getKey() == key) {
                downLoadFileResult = type;
                break;
            }
        }

        return downLoadFileResult;
    }

    public int getKey() {
        return key;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }
}
