package com.xdja.hr.domain.integration;

import com.xdja.hr.domain.original.Employee;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.domain.DayResultRecord<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/26 15:47
 * note:
 */
@Entity
public class DayComputeRecord implements Serializable {
    @Id
    @GeneratedValue
    private Long id;

    @ManyToOne(optional = false)
    @JoinColumn(name = "EMPLOYEE_NO")
    private Employee employee;
    @Column(nullable = false, name = "CREATE_DATE")
    private Date createDate;

    @Column(nullable = true)
    private Boolean isWorkDay;

    /**
     * 加班
     */
    @Column(nullable = true)
    private Double workOvertime;
    /**
     * 补贴,地铁
     */
    @Column(nullable = true)
    private Double assistSubway;
    /**
     * 补贴,早餐
     */
    @Column(nullable = true)
    private Integer assistEatMorning;
    /**
     * 补贴,午餐
     */
    @Column(nullable = true)
    private Integer assistEatMidday;
    /**
     * 补贴,晚餐
     */
    @Column(nullable = true)
    private Integer assistEatAfternoon;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "dayComputeRecord")
    private List<DayStateRecord> dayStateRecords = new ArrayList<DayStateRecord>();

    /**
     * @see com.xdja.hr.utils.RecordType#auto
     * @see com.xdja.hr.utils.RecordType#manual
     */
    @Column
    private Byte recordType;

    public Long getId() {
        return id;
    }

    public Employee getEmployee() {
        return employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Boolean getIsWorkDay() {
        return isWorkDay;
    }

    public void setIsWorkDay(Boolean isWorkDay) {
        this.isWorkDay = isWorkDay;
    }

    public Double getWorkOvertime() {
        return workOvertime;
    }

    public void setWorkOvertime(Double workOvertime) {
        this.workOvertime = workOvertime;
    }

    public Double getAssistSubway() {
        return assistSubway;
    }

    public void setAssistSubway(Double assistSubway) {
        this.assistSubway = assistSubway;
    }

    public Integer getAssistEatMorning() {
        return assistEatMorning;
    }

    public void setAssistEatMorning(Integer assistEatMorning) {
        this.assistEatMorning = assistEatMorning;
    }

    public Integer getAssistEatMidday() {
        return assistEatMidday;
    }

    public void setAssistEatMidday(Integer assistEatMidday) {
        this.assistEatMidday = assistEatMidday;
    }

    public Integer getAssistEatAfternoon() {
        return assistEatAfternoon;
    }

    public void setAssistEatAfternoon(Integer assistEatAfternoon) {
        this.assistEatAfternoon = assistEatAfternoon;
    }

    public List<DayStateRecord> getDayStateRecords() {
        return dayStateRecords;
    }

    public void setDayStateRecords(List<DayStateRecord> dayStateRecords) {
        this.dayStateRecords = dayStateRecords;
    }

    public Byte getRecordType() {
        return recordType;
    }

    public void setRecordType(Byte recordType) {
        this.recordType = recordType;
    }
}
