package com.xdja.hr.domain.integration;

import com.xdja.hr.domain.original.Employee;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * Project Name：hrs <br/>
 * ClassName：DayRecord <br/>
 * Description：TODO <br/>
 *
 * @author: 黄地
 * @date: 2015/7/29 14:24
 * note:
 */
@Entity
public class MonthSummaryRecord implements Serializable {
    @Id
    @GeneratedValue
    private Long id;

    @ManyToOne(optional = false)
    @JoinColumn(name = "EMPLOYEE_NO")
    private Employee employee;
    @Column(nullable = false, name = "CREATE_MONTH")
    private Date createMonth;
    /**
     * 加班
     */
    @Column(nullable = false)
    private Double workOvertime = 0.0;
    /**
     * 请假
     */
    @Column(nullable = false)
    private Double askOff = 0.0;
    /**
     * 迟到
     */
    @Column(nullable = false)
    private Integer arriveLate = 0;
    /**
     * 出差
     */
    @Column(nullable = false)
    private Double evection = 0.0;
    /**
     * 早退
     */
    @Column(nullable = false)
    private Integer leaveEarly = 0;
    /**
     * 旷工
     */
    @Column(nullable = false)
    private Double absenteeism = 0.0;

    /**
     * 补贴,地铁
     */
    @Column(nullable = false)
    private Double assistSubway = 0.0;
    /**
     * 补贴,早餐
     */
    @Column(nullable = false)
    private Integer assistEatMorning = 0;
    /**
     * 补贴,午餐
     */
    @Column(nullable = false)
    private Integer assistEatMidday = 0;
    /**
     * 补贴,晚餐
     */
    @Column(nullable = false)
    private Integer assistEatAfternoon = 0;
    /**
     * @see com.xdja.hr.utils.RecordType#auto
     * @see com.xdja.hr.utils.RecordType#manual
     */
    @Column(nullable = false)
    private Byte recordType;

    public Byte getRecordType() {
        return recordType;
    }

    public void setRecordType(Byte recordType) {
        this.recordType = recordType;
    }

    public Employee getEmployee() {
        return employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Date getCreateMonth() {
        return createMonth;
    }

    public void setCreateMonth(Date createMonth) {
        this.createMonth = createMonth;
    }

    public Double getWorkOvertime() {
        return workOvertime;
    }

    public void setWorkOvertime(Double workOvertime) {
        this.workOvertime = workOvertime;
    }

    public Double getAskOff() {
        return askOff;
    }

    public void setAskOff(Double askOff) {
        this.askOff = askOff;
    }

    public Integer getArriveLate() {
        return arriveLate;
    }

    public void setArriveLate(Integer arriveLate) {
        this.arriveLate = arriveLate;
    }

    public Integer getLeaveEarly() {
        return leaveEarly;
    }

    public void setLeaveEarly(Integer leaveEarly) {
        this.leaveEarly = leaveEarly;
    }

    public Double getAbsenteeism() {
        return absenteeism;
    }

    public void setAbsenteeism(Double absenteeism) {
        this.absenteeism = absenteeism;
    }

    public Double getAssistSubway() {
        return assistSubway;
    }

    public void setAssistSubway(Double assistSubway) {
        this.assistSubway = assistSubway;
    }

    public Integer getAssistEatMorning() {
        return assistEatMorning;
    }

    public void setAssistEatMorning(Integer assistEatMorning) {
        this.assistEatMorning = assistEatMorning;
    }

    public Integer getAssistEatMidday() {
        return assistEatMidday;
    }

    public void setAssistEatMidday(Integer assistEatMidday) {
        this.assistEatMidday = assistEatMidday;
    }

    public Integer getAssistEatAfternoon() {
        return assistEatAfternoon;
    }

    public void setAssistEatAfternoon(Integer assistEatAfternoon) {
        this.assistEatAfternoon = assistEatAfternoon;
    }

    public Long getId() {
        return id;
    }

    public Double getEvection() {
        return evection;
    }

    public void setEvection(Double evection) {
        this.evection = evection;
    }
}
