package com.xdja.hr.pojo;

import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.integration.DayStateRecord;
import com.xdja.hr.domain.original.Employee;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.pojo.ValidDayComputeData<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/27 09:55
 * note:
 */
public class ValidDayComputeData {
    private DayComputeRecord auto;
    private DayComputeRecord manual;

    public void setAuto(DayComputeRecord auto) {
        this.auto = auto;
    }

    public DayComputeRecord getManual() {
        return manual;
    }

    public DayComputeRecord getAuto() {
        return auto;
    }

    public void setManual(DayComputeRecord manual) {
        this.manual = manual;
    }

    public Employee getEmployee() {
        return auto.getEmployee();
    }

    public Date getCreateDate() {
        return auto.getCreateDate();
    }

    public Boolean getIsWorkDay() {
        return auto.getIsWorkDay();
    }


    public List<DayStateRecord> getDayStateRecords() {
        return CollectionUtils.isEmpty(manual.getDayStateRecords()) ? auto.getDayStateRecords() : manual.getDayStateRecords();
    }

    public Integer getAssistEatAfternoon() {
        return firstNotNull(manual.getAssistEatAfternoon(), auto.getAssistEatAfternoon());
    }

    public <T> T firstNotNull(T manual, T auto) {
        return manual != null ? manual : auto;
    }

    public Integer getAssistEatMidday() {
        return firstNotNull(manual.getAssistEatMidday(), auto.getAssistEatMidday());
    }

    public Integer getAssistEatMorning() {
        return firstNotNull(manual.getAssistEatMorning(), auto.getAssistEatMorning());
    }

    public Double getAssistSubway() {
        return firstNotNull(manual.getAssistSubway(), auto.getAssistSubway());
    }

    public Double getWorkOvertime() {
        return firstNotNull(manual.getWorkOvertime(), auto.getWorkOvertime());
    }
}
