package com.xdja.hr.repository;

import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.original.Employee;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

public interface DayComputeRecordRepository extends JpaRepository<DayComputeRecord, Long> {
    @Transactional
    @Modifying
    @Query("delete from #{#entityName} u where  u.createDate >= ?1 and u.createDate < ?2 and u.employee=?3 and u.recordType = ?4 ")
    void deleteByCreateDateAndEmployeeAndRecordType(Date start, Date end, Employee employee, byte recordType);

    @Query("from #{#entityName} u where  u.createDate >= ?1 and u.createDate < ?2 and u.employee=?3")
    List<DayComputeRecord> findByCreateDateAndEmployee(Date start, Date date, Employee employee);
}