package com.xdja.hr.service.compute;

import com.google.common.collect.Sets;
import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.integration.FingerprintRecord;
import com.xdja.hr.domain.integration.RestDayRecord;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.pojo.ValidFingerprintData;
import com.xdja.hr.repository.RepositoryService;
import com.xdja.hr.utils.RecordType;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.service.compute.ComputeService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/26 18:03
 * note:
 */
@Service
public class ComputeService {
    private Logger logger = LoggerFactory.getLogger(getClass());
    @Resource
    private RepositoryService repositoryService;


    public void recomputeDayByMonth(Date month) {
        logger.info("^^重新计算{}考勤", new DateTime(month).toString("yyyy-MM"));
        Date nextMonth = DateUtils.addMonths(month, 1);
        List<Employee> employeeList = repositoryService.getFingerprintRecordRepository().findDistinctEmployeeByCreateDate(month, nextMonth);
        RestDayJudge restDayJudge = getRestDayJudgeByTime(month, nextMonth);
        DayJudgeService judgeService = new DayJudgeService(restDayJudge, new SubwayAssistJudge(), new SeasonJudge());
        for (Employee one : employeeList) {
            recomputeDayByMonth(month, one, judgeService);
        }
        logger.info("$$重新计算{}考勤", new DateTime(month).toString("yyyy-MM"));
    }

    private RestDayJudge getRestDayJudgeByTime(Date month, Date nextMonth) {
        List<RestDayRecord> monthData = repositoryService.getRestDayRecordRepository().findMonthData(month, nextMonth);
        Set<Date> restDaySet = new HashSet<Date>();
        for (RestDayRecord one : monthData) {
            restDaySet.add(one.getCreateDate());
        }
        return new RestDayJudge(restDaySet);
    }

    public void recomputeDayByMonth(Date month, Integer employeeNo) {
        Employee employee = repositoryService.getEmployeeRepository().findOne(employeeNo);
        Date nextMonth = DateUtils.addMonths(month, 1);
        RestDayJudge restDayJudge = getRestDayJudgeByTime(month, nextMonth);
        DayJudgeService judgeService = new DayJudgeService(restDayJudge, new SubwayAssistJudge(), new SeasonJudge());
        recomputeDayByMonth(month, employee, judgeService);
    }

    private void recomputeDayByMonth(Date month, Employee employee, DayJudgeService judgeService) {
        logger.info("^^重新计算{}:{}考勤", employee.getEmployeeName(), new DateTime(month).toString("yyyy-MM"));
        logger.info("获取有效指纹数据");
        Date nextMonth = DateUtils.addMonths(month, 1);
        List<FingerprintRecord> list = repositoryService.getFingerprintRecordRepository().findByCreateDateAndEmployee(month, nextMonth, employee);
        List<ValidFingerprintData> validFingerprintDataList = ComputeUtils.combineValidFingerprintData(list);
        logger.info("执行自动判定,生成判定结果");
        List<DayComputeRecord> computeRecordList = new ArrayList<DayComputeRecord>();
        for (ValidFingerprintData one : validFingerprintDataList) {
            DayComputeRecord dayComputeRecord = judgeService.judge(employee, one);
            computeRecordList.add(dayComputeRecord);
        }
        logger.info("设定判定结果类型为自动{}", RecordType.auto);
        for (DayComputeRecord one : computeRecordList) {
            one.setRecordType(RecordType.auto);
        }
        logger.info("删除旧的判定结果数据");
        deleteOldDayState(month, employee, nextMonth);
        repositoryService.getDayComputeRecordRepository().deleteByCreateDateAndEmployeeAndRecordType(month, nextMonth, employee, RecordType.auto);
        logger.info("保存新的判定结果数据");
        repositoryService.getDayComputeRecordRepository().save(computeRecordList);
        logger.info("$$重新计算{}:{}考勤", employee.getEmployeeName(), new DateTime(month).toString("yyyy-MM"));
    }

    private void deleteOldDayState(Date month, Employee employee, Date nextMonth) {
        List<DayComputeRecord> all = repositoryService.getDayComputeRecordRepository().findByCreateDateAndEmployee(month, nextMonth, employee);
        Set<Long> ids = Sets.newHashSet();
        for (DayComputeRecord one : all) {
            if (one.getRecordType() == RecordType.auto) {
                ids.add(one.getId());
            }
        }
        if (!ids.isEmpty()) {
            repositoryService.getDayStateRecordRepository().deleteByDayComputeRecordIdIn(ids);
        }
    }


}
