package com.xdja.hr.utils;

import com.google.common.collect.Lists;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import java.util.Iterator;
import java.util.List;

/**
 * User: landy
 * Date: 15/7/29
 * Time: 下午7:33
 */
public class ExcelUtils {
    public static Object getCellValue(Cell cell) {
        //System.out.println(cellValue.toString());
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_BOOLEAN:
                return cell.getBooleanCellValue();
            case Cell.CELL_TYPE_NUMERIC:
                return (cell.getNumericCellValue());
            case Cell.CELL_TYPE_STRING:
                return (cell.getStringCellValue());
            case Cell.CELL_TYPE_BLANK:
                return "";
            case Cell.CELL_TYPE_ERROR:
                return cell.getErrorCellValue();
            // CELL_TYPE_FORMULA will never happen
            case Cell.CELL_TYPE_FORMULA:
                throw new IllegalArgumentException("CELL_TYPE_FORMULA will never happen");
            default:
                throw new IllegalArgumentException("Unknow cell type!!!");
        }
    }

    public static String[][] getSheetData(Workbook wb, int sheetIndex) {
        Sheet sheet = wb.getSheetAt(sheetIndex);
        Iterator<Row> rowIterator = sheet.rowIterator();
        List<String[]> rst = Lists.newArrayList();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            List<String> rowList = Lists.newArrayList();
            Iterator<Cell> cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = cellIterator.next();
                String value = ExcelUtils.getCellValue(cell).toString();
                rowList.add(value);
            }
            rst.add(rowList.toArray(new String[0]));
        }
        String[][] arr = rst.toArray(new String[0][]);
        return arr;
    }
}
