package com.xdja.hr.utils;

import java.util.Collection;

/**
 * User: landy
 */
public class JsonResult<T> {
    private boolean success;
    private long total;
    private T data;
    private Object children;
    private String message;

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public JsonResult() {
    }

    public JsonResult(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public JsonResult(boolean success) {

        this.success = success;
    }

    public Object getChildren() {
        return children;
    }

    public void setChildren(Object children) {
        this.children = children;
    }

    public static <T> JsonResult<T> withData(T data) {
        JsonResult<T> tJsonResult = new JsonResult<T>(true);
        tJsonResult.setData(data);
        return tJsonResult;
    }
    public static JsonResult failure(String message) {
        JsonResult tJsonResult = new JsonResult(false);
        tJsonResult.setData(message);
        tJsonResult.setMessage(message);
        return tJsonResult;
    }

    public static JsonResult gridData(long total, Collection data) {
        JsonResult jr = new JsonResult();
        jr.setSuccess(true);
        jr.setTotal(total);
        jr.setData(data);
        return jr;
    }
    public static JsonResult gridData(long total, Object[] data) {
        JsonResult jr = new JsonResult();
        jr.setSuccess(true);
        jr.setTotal(total);
        jr.setData(data);
        return jr;
    }

    public static JsonResult treeData(Collection data) {
        JsonResult tJsonResult = new JsonResult(true);
        tJsonResult.setChildren(data);
        return tJsonResult;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}