package com.xdja.hr.web.config;

import com.xdja.hr.utils.JsonResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * User: landy
 * Date: 15/8/2
 * Time: 下午12:16
 */
@ControllerAdvice
public class CustomExceptionHandler {
    final Logger logger = LoggerFactory.getLogger(getClass());
    @ExceptionHandler
    @ResponseBody
    public JsonResult handle(Exception e) {
        logger.error("未捕获的异常", e);
        return JsonResult.failure(e.getClass().getSimpleName() + ":" + e.getMessage());
    }
}
