package com.xdja.hr.web.config;

import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.stereotype.Component;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;
import java.util.UUID;

/**
 * User: landy
 * Date: 15/8/2
 * Time: 下午12:05
 */
@Component
public class MvcConfig extends WebMvcConfigurerAdapter {
    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        SortHandlerMethodArgumentResolver sort = new SortHandlerMethodArgumentResolver();
        sort.setSortParameter(UUID.randomUUID().toString());
        PageableHandlerMethodArgumentResolver handler = new PageableHandlerMethodArgumentResolver(sort);
        handler.setSizeParameterName("limit");
        handler.setOneIndexedParameters(true);
        argumentResolvers.add(handler);
    }
}
