package com.xdja.hr.domain.integration;

import com.xdja.hr.domain.original.Employee;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.domain.FingerprintRecord<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/26 15:38
 * note:
 */
@Entity
public class FingerprintRecord implements Serializable {
    @Id
    @GeneratedValue
    private Long id;
    @ManyToOne(optional = false)
    @JoinColumn(name = "EMPLOYEE_NO")
    private Employee employee;
    @Column(nullable = false, name = "CREATE_DATE")
    private Date createDate;

    @Column(nullable = true)
    private Date morningTime;

    @Column(nullable = true)
    private Date middayTime1;

    @Column(nullable = true)
    private Date middayTime2;

    @Column(nullable = true)
    private Date afternoonTime;
    /**
     * @see com.xdja.hr.utils.RecordType#auto
     * @see com.xdja.hr.utils.RecordType#manual
     */
    @Column
    private Byte recordType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getMorningTime() {
        return morningTime;
    }

    public void setMorningTime(Date morningTime) {
        this.morningTime = morningTime;
    }

    public Date getMiddayTime1() {
        return middayTime1;
    }

    public void setMiddayTime1(Date middayTime1) {
        this.middayTime1 = middayTime1;
    }

    public Date getMiddayTime2() {
        return middayTime2;
    }

    public void setMiddayTime2(Date middayTime2) {
        this.middayTime2 = middayTime2;
    }

    public Date getAfternoonTime() {
        return afternoonTime;
    }

    public void setAfternoonTime(Date afternoonTime) {
        this.afternoonTime = afternoonTime;
    }

    public Byte getRecordType() {
        return recordType;
    }

    public void setRecordType(Byte recordType) {
        this.recordType = recordType;
    }
}
