package com.xdja.hr.domain.original;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * User: landy
 * Date: 15/8/2
 * Time: 下午12:59
 */
@Entity
public class Employee {
    @Id
    private Integer employeeNo;
    @Column(nullable = false)
    private String employeeName;
    @Column(nullable = false)
    private String department;

    public Employee() {
    }

    public Employee(Integer employeeNo, String employeeName,String department) {
        this.employeeNo = employeeNo;
        this.employeeName = employeeName;
        this.department=department;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Integer getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(Integer employeeNo) {
        this.employeeNo = employeeNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Employee)) return false;

        Employee employee = (Employee) o;

        if (!employeeNo.equals(employee.employeeNo)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return employeeNo.hashCode();
    }

    @Override
    public String toString() {
        return "Employee{" +
                "employeeName='" + employeeName + '\'' +
                ", employeeNo=" + employeeNo +
                '}';
    }
}
