package com.xdja.hr.repository;

import com.xdja.hr.domain.integration.FingerprintRecord;
import com.xdja.hr.domain.original.Employee;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

public interface FingerprintRecordRepository extends JpaRepository<FingerprintRecord, Long> {
    @Transactional
    @Modifying
    @Query("delete from #{#entityName} u where  u.createDate >= ?1 and u.createDate < ?2 and u.recordType = ?3 ")
    void deleteByCreateDateAndRecordType(Date start, Date end, byte original);

    @Query("from #{#entityName} u where  u.createDate >= ?1 and u.createDate < ?2 and u.employee=?3")
    List<FingerprintRecord> findByCreateDateAndEmployee(Date start, Date end, Employee employee);

    @Query("select distinct u.employee from #{#entityName} u where  u.createDate >= ?1 and u.createDate < ?2")
    List<Employee> findDistinctEmployeeByCreateDate(Date start, Date end);
}