package com.xdja.hr.repository;

import com.xdja.hr.domain.integration.MonthSummaryRecord;
import com.xdja.hr.domain.original.Employee;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

public interface MonthRecordRepository extends JpaRepository<MonthSummaryRecord, Long>, MonthRecordRepositoryCustom {
    List<MonthSummaryRecord> findByCreateMonth(Date month);

    MonthSummaryRecord findByEmployeeAndCreateMonth(Employee employee, Date createMonth);

    @Transactional
    @Modifying
    @Query("delete from #{#entityName} u where  u.createMonth >= ?1 and u.createMonth < ?2 ")
    void deleteByTime(Date start, Date end);

    @Transactional
    @Modifying
    @Query("delete from #{#entityName} u where u.employee=?1 and  u.createMonth >= ?2 and u.createMonth < ?3 ")
    void deleteByEmployeeAndTime(Employee employee, Date start, Date end);
}