package com.xdja.hr.repository;

import com.xdja.hr.domain.original.OfficeAutomation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

public interface OfficeAutomationRepository extends JpaRepository<OfficeAutomation, Long> {
    @Query("select u from #{#entityName} u left join FETCH u.employee e where u.createDate >= ?1 and u.createDate < ?2 ")
    List<OfficeAutomation> findMonthData(Date start, Date end);

    @Transactional
    @Modifying
    @Query("delete from #{#entityName} u where  u.createDate >= ?1 and u.createDate < ?2 ")
    void deleteByCreateDate(Date start, Date end);
}