package com.xdja.hr.repository;

import com.xdja.hr.domain.integration.RestDayRecord;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;

public interface RestDayRecordRepository extends JpaRepository<RestDayRecord, Long> {
    @Query("select u from #{#entityName} u  where u.createDate >= ?1 and u.createDate < ?2 order by u.createDate asc")
    List<RestDayRecord> findMonthData(Date start, Date end);

    RestDayRecord findByCreateDate(Date restDay);
}