package com.xdja.hr.repository.impl;

import com.xdja.hr.domain.integration.MonthSummaryRecord;
import com.xdja.hr.repository.MonthRecordRepositoryCustom;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * User: landy
 * Date: 15/8/10
 * Time: 下午10:53
 */
@Repository
public class MonthRecordRepositoryImpl implements MonthRecordRepositoryCustom {
    @Resource
    private EntityManager entityManager;

    @Override
    public Page<MonthSummaryRecord> findAllByCreateMonthOrderByEmployeeAsc(Date month, Pageable page) {
        String hql = "from MonthSummaryRecord r left join fetch r.employee e where r.createMonth=?1 order by r.employee asc";
        String countHql = "select count(r) from MonthSummaryRecord r where r.createMonth=?1";
        Long total = entityManager.createQuery(countHql, Long.class).setParameter(1, month).getSingleResult();
        TypedQuery<MonthSummaryRecord> query = entityManager.createQuery(hql, MonthSummaryRecord.class)
                .setParameter(1, month);
        List<MonthSummaryRecord> content = null;
        if (page != null) {
            query.setFirstResult(page.getOffset())
                    .setMaxResults(page.getPageSize());
            content = total > page.getOffset() ? query.getResultList() : Collections.<MonthSummaryRecord>emptyList();
        } else {
            content = query.getResultList();
        }

        return new PageImpl<MonthSummaryRecord>(content, page, total);
    }
}
