package com.xdja.hr.service.compute;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.integration.DayStateRecord;
import com.xdja.hr.domain.integration.FingerprintRecord;
import com.xdja.hr.domain.integration.MonthSummaryRecord;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.pojo.ValidDayComputeData;
import com.xdja.hr.pojo.ValidFingerprintData;
import com.xdja.hr.pojo.ValidFullData;
import com.xdja.hr.utils.DayState;
import com.xdja.hr.utils.RecordType;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.Assert;

import java.util.*;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.service.compute.ComputeUtils<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/27 09:51
 * note:
 */
public class ComputeUtils {

    public static List<ValidFingerprintData> combineValidFingerprintData(List<FingerprintRecord> list) {

        Map<Employee, Map<Date, ValidFingerprintData>> map = Maps.newHashMap();
        for (FingerprintRecord one : list) {
            if (!map.containsKey(one.getEmployee())) {
                map.put(one.getEmployee(), Maps.<Date, ValidFingerprintData>newHashMap());
            }
            if (!map.get(one.getEmployee()).containsKey(one.getCreateDate())) {
                map.get(one.getEmployee()).put(one.getCreateDate(), new ValidFingerprintData());
            }
            if (one.getRecordType() == RecordType.auto) {
                map.get(one.getEmployee()).get(one.getCreateDate()).setOriginal(one);
            } else if (one.getRecordType() == RecordType.manual) {
                map.get(one.getEmployee()).get(one.getCreateDate()).setManual(one);
            }
        }
        List<ValidFingerprintData> result = new ArrayList<ValidFingerprintData>();
        for (Map<Date, ValidFingerprintData> one : map.values()) {
            for (ValidFingerprintData tmp : one.values()) {
                if (tmp.getManual() == null) {
                    FingerprintRecord manual = new FingerprintRecord();
                    manual.setRecordType(RecordType.manual);
                    tmp.setManual(manual);
                }
                if (tmp.getOriginal() == null) {
                    throw new RuntimeException("有修订记录，但是没有原始original记录？");
                }
                result.add(tmp);
            }
        }
        Collections.sort(result, new Comparator<ValidFingerprintData>() {
            @Override
            public int compare(ValidFingerprintData o1, ValidFingerprintData o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });

        return result;
    }

    public static List<ValidDayComputeData> combineValidDayComputeData(List<DayComputeRecord> dayRecords) {
        Map<Employee, Map<Date, ValidDayComputeData>> map = Maps.newHashMap();
        for (DayComputeRecord one : dayRecords) {
            if (!map.containsKey(one.getEmployee())) {
                map.put(one.getEmployee(), Maps.<Date, ValidDayComputeData>newHashMap());
            }
            if (!map.get(one.getEmployee()).containsKey(one.getCreateDate())) {
                map.get(one.getEmployee()).put(one.getCreateDate(), new ValidDayComputeData());
            }
            if (one.getRecordType() == RecordType.auto) {
                map.get(one.getEmployee()).get(one.getCreateDate()).setAuto(one);
            } else if (one.getRecordType() == RecordType.manual) {
                map.get(one.getEmployee()).get(one.getCreateDate()).setManual(one);
            }
        }
        List<ValidDayComputeData> result = new ArrayList<ValidDayComputeData>();
        for (Map<Date, ValidDayComputeData> one : map.values()) {
            for (ValidDayComputeData tmp : one.values()) {
                if (tmp.getManual() == null) {
                    DayComputeRecord manual = new DayComputeRecord();
                    manual.setRecordType(RecordType.manual);
                    tmp.setManual(manual);
                }
                if (tmp.getAuto() == null) {
                    throw new RuntimeException("有修订记录，但是没有原始auto记录？");
                }
                result.add(tmp);
            }
        }
        Collections.sort(result, new Comparator<ValidDayComputeData>() {
            @Override
            public int compare(ValidDayComputeData o1, ValidDayComputeData o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });
        return result;
    }

    public static List<ValidFullData> combineValidFullData(List<ValidFingerprintData> fingerprintDatas, List<ValidDayComputeData> computeDatas) {
        Assert.isTrue(fingerprintDatas.size() == computeDatas.size(), "参数列表长度不一致");
        Map<Employee, Map<Date, ValidFullData>> map = Maps.newHashMap();
        for (ValidFingerprintData one : fingerprintDatas) {
            if (!map.containsKey(one.getEmployee())) {
                map.put(one.getEmployee(), Maps.<Date, ValidFullData>newHashMap());
            }
            if (!map.get(one.getEmployee()).containsKey(one.getCreateDate())) {
                map.get(one.getEmployee()).put(one.getCreateDate(), new ValidFullData());
            }
            map.get(one.getEmployee()).get(one.getCreateDate()).setFingerprintData(one);
        }
        for (ValidDayComputeData one : computeDatas) {
            map.get(one.getEmployee()).get(one.getCreateDate()).setComputeData(one);
        }
        List<ValidFullData> result = new ArrayList<ValidFullData>();
        for (Map<Date, ValidFullData> oneMap : map.values()) {
            for (ValidFullData one : oneMap.values()) {
                result.add(one);
            }
        }
        Collections.sort(result, new Comparator<ValidFullData>() {
            @Override
            public int compare(ValidFullData o1, ValidFullData o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });
        return result;
    }

    public static MonthSummaryRecord doMonthSummary(List<ValidDayComputeData> mergeDataList) {

        ValidDayComputeData first = Iterables.getFirst(mergeDataList, null);
        if (first == null) {
            return null;
        }
        Employee employee = first.getEmployee();
        Date month = DateUtils.truncate(first.getCreateDate(), Calendar.MONTH);

        MonthSummaryRecord monthSummaryRecord = new MonthSummaryRecord();
        monthSummaryRecord.setEmployee(employee);
        monthSummaryRecord.setCreateMonth(month);
        monthSummaryRecord.setRecordType(RecordType.auto);

        int totalAssistMorning = 0;
        int totalAssistMidday = 0;
        int totalAssistAfternoon = 0;
        double totalAssistSubway = 0;
        double totalWorkOvertime = 0.0;
        double totalAbsenteeism = 0.0;
        double totalAskOff = 0.0;
        double totalEvection = 0.0;
        int totalLeaveEarly = 0;
        int totalArriveLate = 0;

        for (ValidDayComputeData one : mergeDataList) {
            totalAssistAfternoon += one.getAssistEatAfternoon();
            totalAssistMidday += one.getAssistEatMidday();
            totalAssistMorning += one.getAssistEatMorning();
            totalAssistSubway += one.getAssistSubway();
            totalWorkOvertime += one.getWorkOvertime();
            for (DayStateRecord tmp : one.getDayStateRecords()) {
                DayState dayState = tmp.getDayState();
                switch (dayState) {
                    case Absent:
                        totalAbsenteeism += 1;
                        break;
                    case HalfAbsent:
                        totalAbsenteeism += 0.5;
                        break;
                    case Evection:
                        totalEvection += 1;
                        break;
                    case AskOff:
                        totalAskOff += 1;
                        break;
                    case ArriveLate:
                        totalArriveLate += 1;
                        break;
                    case LeaveEarly:
                        totalLeaveEarly += 1;
                        break;
                    case Work:
                        break;
                }
            }
        }

        monthSummaryRecord.setWorkOvertime(totalWorkOvertime);
        monthSummaryRecord.setAssistSubway(totalAssistSubway);
        monthSummaryRecord.setAssistEatMorning(totalAssistMorning);
        monthSummaryRecord.setAssistEatMidday(totalAssistMidday);
        monthSummaryRecord.setAssistEatAfternoon(totalAssistAfternoon);

        monthSummaryRecord.setAbsenteeism(totalAbsenteeism);
        monthSummaryRecord.setEvection(totalEvection);
        monthSummaryRecord.setAskOff(totalAskOff);
        monthSummaryRecord.setLeaveEarly(totalLeaveEarly);
        monthSummaryRecord.setArriveLate(totalArriveLate);
        return monthSummaryRecord;
    }
}
