package com.xdja.hr.service.compute;

import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.pojo.ValidFingerprintData;
import com.xdja.hr.service.compute.judgeTool.SummerRestDayJudge;
import com.xdja.hr.service.compute.judgeTool.SummerWorkDayJudge;
import com.xdja.hr.service.compute.judgeTool.WinterWorkDayJudge;

import java.util.Date;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.service.compute.JudgeService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/26 18:29
 * note:
 */
public class DayJudgeService {
    private RestDayJudge restDayJudge;
    private SubwayAssistJudge subwayAssistJudge;
    private SeasonJudge seasonJudge;

    public DayJudgeService(RestDayJudge restDayJudge, SubwayAssistJudge subwayAssistJudge, SeasonJudge seasonJudge) {
        this.restDayJudge = restDayJudge;
        this.subwayAssistJudge = subwayAssistJudge;
        this.seasonJudge = seasonJudge;
    }

    public DayComputeRecord judge(Employee employee, ValidFingerprintData validData) {
        IJudge tool = getJudgeTool(employee, validData.getCreateDate());
        DayComputeRecord result = tool.judge(employee, validData);
        if (!subwayAssistJudge.hasAssist(employee, validData.getCreateDate())) {
            result.setAssistSubway(0.0);
        }
        return result;
    }

    private IJudge getJudgeTool(Employee employee, Date createDate) {
        if (restDayJudge.isRest(createDate)) {
            return new SummerRestDayJudge();
        } else {
            SeasonJudge.SeasonType seasonType = seasonJudge.judge(createDate);
            if (seasonType == SeasonJudge.SeasonType.Summer) {
                return new SummerWorkDayJudge();
            } else if (seasonType == SeasonJudge.SeasonType.Winter) {
                return new WinterWorkDayJudge();
            }
        }
        throw new RuntimeException("无法确定JudgeTool");
    }
}
