package com.xdja.hr.service.compute;

import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.integration.MonthSummaryRecord;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.pojo.ValidDayComputeData;
import com.xdja.hr.repository.RepositoryService;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * User: landy
 * Date: 15/8/19
 * Time: 下午10:01
 */
@Service
public class MonthSummaryService {
    private Logger logger = LoggerFactory.getLogger(getClass());
    @Resource
    private RepositoryService repositoryService;

    /**
     * 执行总结
     *
     * @param month
     */
    public void doSummary(Date month) {
        logger.info("### 对月数据进行统计总结");
        Date nextMonth = DateUtils.addMonths(month, 1);
        repositoryService.getMonthRecordRepository().deleteByTime(month, nextMonth);
        List<Employee> all = repositoryService.getFingerprintRecordRepository().findDistinctEmployeeByCreateDate(month, nextMonth);
        for (Employee employee : all) {
            doSummary(month, employee, false);
        }

    }

    public void doSummary(Date month, Employee employee, boolean delete) {
        if (delete) {
            repositoryService.getMonthRecordRepository().deleteByEmployeeAndTime(employee, month, DateUtils.addMonths(month, 1));
        }
        List<DayComputeRecord> dayRecords = repositoryService.getDayComputeRecordRepository().findByCreateDateAndEmployee(month, DateUtils.addMonths(month, 1), employee);
        List<ValidDayComputeData> mergeDataList = ComputeUtils.combineValidDayComputeData(dayRecords);
        logger.info("计算原始的月总结信息:"+employee.getEmployeeName());
        MonthSummaryRecord monthSummaryRecord = ComputeUtils.doMonthSummary(mergeDataList);
        repositoryService.getMonthRecordRepository().save(monthSummaryRecord);
    }
}
