package com.xdja.hr.service.compute.judgeTool;

import com.xdja.hr.pojo.ValidFingerprintData;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

import java.util.Date;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.service.compute.judgeTool.JudgeToolUtils<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/26 23:20
 * note:
 */
public class JudgeUtils {
    public static int assistMorning(ValidFingerprintData data, LocalTime line) {
        Date time = data.getMorningTime();
        if (time != null) {
            LocalTime morningTime = new DateTime(time).toLocalTime();
            if (!morningTime.isAfter(line)) {
                return 1;
            }
        }
        return 0;
    }

    public static int assistMidday(ValidFingerprintData data, LocalTime begin, LocalTime end) {
        if (hasMiddayEatAssist(data.getMiddayTime1(), begin, end) || hasMiddayEatAssist(data.getMiddayTime2(), begin, end)) {
            return 1;
        }
        return 0;
    }

    private static boolean hasMiddayEatAssist(Date mtime, LocalTime begin, LocalTime end) {
        if (mtime == null) {
            return false;
        }
        LocalTime middayTime = new DateTime(mtime).toLocalTime();
        if (middayTime.isAfter(begin) && middayTime.isBefore(end)) {
            return true;
        }
        return false;
    }

    public static int assistAfternoon(ValidFingerprintData data, LocalTime line) {
        Date time = data.getAfternoonTime();
        if (time != null) {
            LocalTime afternoonTime = new DateTime(time).toLocalTime();
            if (afternoonTime.isAfter(line)) {
                return 1;
            }
        }
        return 0;
    }

    public static double assistSubway(ValidFingerprintData data) {
        double result = 0.0;
        if (data.getMorningTime() != null) {
            result += 0.5;
        }
        if (data.getAfternoonTime() != null) {
            result += 0.5;
        }
        return result;
    }
}
