package com.xdja.hr.service.importData;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.domain.original.OfficeAutomation;
import com.xdja.hr.utils.ExcelUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * User: landy
 * Date: 15/8/19
 * Time: 下午9:27
 */
class ImportOfficeAutomation {
    private static final Logger logger = LoggerFactory.getLogger(ImportOfficeAutomation.class);
    private final static int nameIdx = 1;
    private final static int dayIdx = 2;

    /**
     * 解析oa数据
     *
     * @param file
     */
    public static List<OfficeAutomation> parseOfficeAutomationData(InputStream file, Date monthDate, List<Employee> allEmployee) throws IOException, InvalidFormatException {
        logger.info("解析oa数据");
        Workbook wb = WorkbookFactory.create(file);
        String[][] data = ExcelUtils.getSheetData(wb, 0);
        DateTime month = new DateTime(monthDate);
        Map<String, Employee> name2no = getEmployeeNameToNoMap(allEmployee);
        int maximumValue = month.dayOfMonth().getMaximumValue();
        int headerLen = data[1].length;
        for (int i = 1; i < data.length; i++) {
            String[] one = data[i];
            Preconditions.checkArgument(one.length == headerLen);
        }
        List<OfficeAutomation> rst = Lists.newArrayList();
        for (int i = 2; i < data.length; i++) {
            String[] row = data[i];

            String empolyeeName = row[nameIdx];
            int day = 0;
            for (int col = dayIdx; col < row.length; col++, day++) {
                if (day < maximumValue) {
                    DateTime tmp = month.plusDays(day);
                    //本月才会计算,排除非本月的情况
                    String content = row[col];
                    if (StringUtils.hasText(content)) {

                        OfficeAutomation oa = new OfficeAutomation();
                        oa.setContent(content);
                        oa.setCreateDate(tmp.toDate());
                        Employee employee = name2no.get(empolyeeName);
                        if (employee != null) {
                            oa.setEmployee(employee);
                            rst.add(oa);
                        } else {
                            logger.error("OA存在但是指纹不存在的员工:" + empolyeeName);
                        }
                    }
                } else {
                    //非本月
                }
            }
        }
        return rst;
    }

    private static Map<String, Employee> getEmployeeNameToNoMap(List<Employee> distinctEmployee) {
        Map<String, Employee> rst = Maps.newHashMap();
        for (Employee one : distinctEmployee) {
            rst.put(one.getEmployeeName(), one);
        }
        return rst;
    }
}
