package com.xdja.hr.service.importData;

import com.google.common.collect.Sets;
import com.xdja.hr.domain.integration.FingerprintRecord;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.domain.original.OfficeAutomation;
import com.xdja.hr.pojo.Fingerprint;
import com.xdja.hr.repository.RepositoryService;
import com.xdja.hr.utils.RecordType;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.service.ImportService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/26 16:50
 * note:
 */
@Service
public class ImportService {
    private Logger logger = LoggerFactory.getLogger(getClass());
    @Resource
    private RepositoryService repositoryService;

    public void importEmployeeData(InputStream file) throws IOException, InvalidFormatException {
        logger.info("### 开始导入 员工信息");
        List<Fingerprint> fingerprintList = ImportFingerprint.parseFingerprintData(file);
        Set<Employee> employeeSet = Sets.newLinkedHashSet();
        for (Fingerprint one : fingerprintList) {
            employeeSet.add(one.getEmployee());
        }
        repositoryService.getEmployeeRepository().save(employeeSet);
        logger.info("### 结束导入 员工信息");
    }

    public void importOriginalFingerprintData(InputStream file, Date month) throws IOException, InvalidFormatException {
        logger.info("### 开始导入 原始 指纹数据");
        byte recordType = RecordType.auto;
        importFingerprintData(file, month, recordType);
        logger.info("### 结束导入 原始 指纹数据");
    }

    private void importFingerprintData(InputStream file, Date month, byte recordType) throws IOException, InvalidFormatException {
        //解析出新数据
        List<Fingerprint> fingerprintList = ImportFingerprint.parseFingerprintData(file);

        Set<Employee> employeeSet = Sets.newLinkedHashSet();
        for (Fingerprint one : fingerprintList) {
            employeeSet.add(one.getEmployee());
            Assert.isTrue(one.getCreateDate().getMonth() == month.getMonth(), "上传数据月份与选择月份不一致！");
        }
        logger.info("将原始指纹数据合并成每天一条，格式良好的数据");
        Map<Employee, List<FingerprintRecord>> dayRecordList = ImportFingerprint.mergeDailyData(fingerprintList);

        logger.info("设置数据类型为原始数据");
        for (List<FingerprintRecord> records : dayRecordList.values()) {
            for (FingerprintRecord record : records) {
                record.setRecordType(recordType);
            }
        }
        logger.info("删除旧数据");
        repositoryService.getFingerprintRecordRepository().deleteByCreateDateAndRecordType(month, DateUtils.addMonths(month, 1), recordType);
        logger.info("保存新数据");
        for (List<FingerprintRecord> records : dayRecordList.values()) {
            repositoryService.getFingerprintRecordRepository().save(records);
        }
    }

    public void importManualFingerprintData(InputStream file, Date month) throws IOException, InvalidFormatException {
        logger.info("### 开始导入 修订 指纹数据");
        importFingerprintData(file, month, RecordType.manual);
        logger.info("### 结束导入 修订 指纹数据");
    }

    public void importSubwayAssistData() {
    }

    public void importOAData(InputStream file, Date month) throws IOException, InvalidFormatException {
        logger.info("### 开始导入oa数据");
        List<Employee> all = repositoryService.getEmployeeRepository().findAll();
        List<OfficeAutomation> officeAutomationList = ImportOfficeAutomation.parseOfficeAutomationData(file, month, all);
        logger.info("删除旧数据");
        repositoryService.getOfficeAutomationRepository().deleteByCreateDate(month, DateUtils.addMonths(month, 1));
        logger.info("保存新数据");
        repositoryService.getOfficeAutomationRepository().save(officeAutomationList);
        logger.info("### 结束导入oa数据");
    }
}
