package com.xdja.hr.utils;

import com.xdja.hr.domain.integration.DayComputeRecord;
import com.xdja.hr.domain.integration.DayStateRecord;
import com.xdja.hr.domain.integration.FingerprintRecord;
import com.xdja.hr.domain.original.Employee;
import com.xdja.hr.pojo.ValidDayComputeData;
import com.xdja.hr.pojo.ValidFingerprintData;
import com.xdja.hr.pojo.ValidFullData;
import com.xdja.hr.repository.RepositoryService;
import com.xdja.hr.service.compute.ComputeUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.joda.time.DateTime;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.utils.MonthExcelView<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/22 22:26
 * note:
 */
public class DayExcelView extends AbstractExcelView {
    private final static LinkedHashMap<String, String> ColumnsMap = new LinkedHashMap<String, String>();
    private DateFormat DATE_FMT = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat TIME_FMT = new SimpleDateFormat("HH:mm");

    static {
        ColumnsMap.put("部门", "");
        ColumnsMap.put("工号", "");
        ColumnsMap.put("姓名", "");
        ColumnsMap.put("日期", "");
        ColumnsMap.put("星期", "");
        ColumnsMap.put("日期类型", "");
        ColumnsMap.put("早", "");
        ColumnsMap.put("中", "");
        ColumnsMap.put("晚", "");
        ColumnsMap.put("加班", "");
        ColumnsMap.put("地铁补住", "");
        ColumnsMap.put("餐补（早）", "");
        ColumnsMap.put("餐补（中）", "");
        ColumnsMap.put("餐补（晚）", "");
        ColumnsMap.put("状态", "");
    }

    private final RepositoryService repositoryService;

    public DayExcelView(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    protected void buildExcelDocument(Map<String, Object> model, HSSFWorkbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Date month = (Date) model.get("month");
        List<Integer> ids = (List<Integer>) model.get("ids");
        String monthStr = new DateTime(month).toString("yyyy-MM");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + monthStr + "-detail.xls\"");
        if (!CollectionUtils.isEmpty(ids)) {
            HSSFSheet sheet = workbook.createSheet(monthStr);
            int rowIdx = 0;
            int cellIdx = 0;
            for (String key : ColumnsMap.keySet()) {
                HSSFCell cell = getCell(sheet, rowIdx, cellIdx++);
                setText(cell, key);
            }
            rowIdx++;
            Date nextMonth = DateUtils.addMonths(month, 1);
            for (Integer no : ids) {
                Employee employee = repositoryService.getEmployeeRepository().findOne(no);
                List<FingerprintRecord> fingerprintRecords = repositoryService.getFingerprintRecordRepository().findByCreateDateAndEmployee(month, nextMonth, employee);
                List<DayComputeRecord> dayComputeRecords = repositoryService.getDayComputeRecordRepository().findByCreateDateAndEmployee(month, nextMonth, employee);
                List<ValidFingerprintData> validFingerprintDataList = ComputeUtils.combineValidFingerprintData(fingerprintRecords);
                List<ValidDayComputeData> validDayComputeDatas = ComputeUtils.combineValidDayComputeData(dayComputeRecords);
                List<ValidFullData> validFullDatas = ComputeUtils.combineValidFullData(validFingerprintDataList, validDayComputeDatas);

                if (!CollectionUtils.isEmpty(validFullDatas)) {
                    for (ValidFullData one : validFullDatas) {
                        cellIdx = 0;
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(employee.getDepartment()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(employee.getEmployeeNo()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(employee.getEmployeeName()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(toDateFmt(one.getFingerprintData().getCreateDate())));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(new DateTime(one.getFingerprintData().getCreateDate()).getDayOfWeek()));
                        Boolean isWorkDay = one.getComputeData().getIsWorkDay();
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(isWorkDay ? "" : "休息日"));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(toTimeFmt(one.getFingerprintData().getMorningTime())));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(toTimeFmt(one.getFingerprintData().getMiddayTime())));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(toTimeFmt(one.getFingerprintData().getAfternoonTime())));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(one.getComputeData().getWorkOvertime()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(one.getComputeData().getAssistSubway()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(one.getComputeData().getAssistEatMorning()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(one.getComputeData().getAssistEatMidday()));
                        setText(getCell(sheet, rowIdx, cellIdx++), safeToString(one.getComputeData().getAssistEatAfternoon()));
                        for (DayStateRecord stateRecord : one.getComputeData().getDayStateRecords()) {
                            setText(getCell(sheet, rowIdx, cellIdx++), safeToString(stateRecord.getDayState().toDesc()));
                        }
                        rowIdx++;
                    }
                }

            }
        }

    }

    private String toTimeFmt(Date date) {
        if (date != null) {
            return TIME_FMT.format(date);
        } else {
            return "";
        }
    }

    private String toDateFmt(Date date) {
        if (date != null) {
            return DATE_FMT.format(date);
        } else {
            return "";
        }
    }

    private String safeToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static void main(String[] args) {
        System.out.println(ColumnsMap.keySet());
    }
}
