package com.xdja.hr.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.base.Preconditions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * User: landy
 * Date: 15/7/29
 * Time: 下午8:32
 */
public class JsonUtils {
    public final static ObjectMapper JSON = new ObjectMapper();

    public static String toJson(Object object) throws JsonProcessingException {
        Preconditions.checkNotNull(object);
        return JSON.writeValueAsString(object);
    }

    public static Map<String, String> toStrMap(String json) throws IOException {
        Preconditions.checkNotNull(json);
        MapType mapType = JSON.getTypeFactory().constructMapType(HashMap.class, String.class, String.class);
        Map<String, String> rst = JSON.readValue(json, mapType);
        return rst;
    }
}
