package com.xdja.hr.utils;

import com.xdja.hr.domain.integration.MonthSummaryRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.joda.time.DateTime;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Project Name：hrinfo<br/>
 * ClassName： com.xdja.hr.utils.MonthExcelView<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/09/22 22:26
 * note:
 */
public class MonthExcelView extends AbstractExcelView {
    private final static LinkedHashMap<String, String> ColumnsMap = new LinkedHashMap<String, String>();

    static {
        ColumnsMap.put("工号", "employeeNo");
        ColumnsMap.put("部门", "department");
        ColumnsMap.put("姓名", "employeeName");
        ColumnsMap.put("加班（时）", "workOvertime");
        ColumnsMap.put("请假（天）", "askOff");
        ColumnsMap.put("迟到（次）", "arriveLate");
        ColumnsMap.put("早退（次）", "leaveEarly");
        ColumnsMap.put("旷工（天）", "absenteeism");
        ColumnsMap.put("地铁补助（次）", "assistSubway");
        ColumnsMap.put("餐补（早）", "assistEatMorning");
        ColumnsMap.put("餐补（中）", "assistEatMidday");
        ColumnsMap.put("餐补（晚）", "assistEatAfternoon");
    }

    @Override
    protected void buildExcelDocument(Map<String, Object> model, HSSFWorkbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Date month = (Date) model.get("month");
        List<MonthSummaryRecord> dataList = (List<MonthSummaryRecord>) model.get("dataList");

        String sheetname = new DateTime(month).toString("yyyy-MM");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + sheetname + "-overview.xls\"");
        HSSFSheet sheet = workbook.createSheet(sheetname);
        int rowIdx = 0;
        int cellIdx = 0;
        for (String key : ColumnsMap.keySet()) {
            HSSFCell cell = getCell(sheet, rowIdx, cellIdx++);
            setText(cell, key);
        }
        rowIdx++;


        for (MonthSummaryRecord one : dataList) {
            Map<String, Object> tmp = new HashMap<String, Object>(BeanMap.create(one));
            tmp.put("employeeNo", one.getEmployee().getEmployeeNo());
            tmp.put("department", one.getEmployee().getDepartment());
            tmp.put("employeeName", one.getEmployee().getEmployeeName());

            cellIdx = 0;
            for (String key : ColumnsMap.keySet()) {
                String value = ColumnsMap.get(key);
                Object obj = tmp.get(value);
                HSSFCell cell = getCell(sheet, rowIdx, cellIdx++);
                setText(cell, ObjectUtils.nullSafeToString(obj));
            }
            rowIdx++;
        }
    }

    public static void main(String[] args) {
        System.out.println(ColumnsMap.keySet());
    }
}
