/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.iam.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.iam.client.IAMClient;
import com.xdja.iam.exception.IAMRequestException;
import com.xdja.iam.exception.ProfileInvalidException;
import com.xdja.iam.logger.LoggerUtil;
import com.xdja.iam.model.AuthCodeRequest;
import com.xdja.iam.model.ErrorInfo;
import com.xdja.iam.model.HttpClientResult;
import com.xdja.iam.model.IAMResult;
import com.xdja.iam.model.TokenRequest;
import com.xdja.iam.model.TokenResponse;
import com.xdja.iam.profile.ClientProfile;
import com.xdja.iam.profile.ManageClientProfile;
import com.xdja.iam.profile.OperateClientProfile;
import com.xdja.iam.tool.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultIAMClient
implements IAMClient {
    private ClientProfile clientProfile;

    public DefaultIAMClient(String profileType) {
        if (profileType.equals("operate")) {
            this.clientProfile = OperateClientProfile.newInstance();
        } else if (profileType.equals("manage")) {
            this.clientProfile = ManageClientProfile.newInstance();
        } else {
            throw new ProfileInvalidException("unknown profile type");
        }
        this.checkClientProfile();
    }

    @Override
    public String constructAuthCodeUrl(AuthCodeRequest authCodeRequest) {
        if (authCodeRequest == null) {
            throw new IAMRequestException("auth code request param can not be null");
        }
        String httpHeader = this.createHttpsRequestHead(this.clientProfile);
        StringBuffer authCodeUrl = new StringBuffer(httpHeader + "/api/v1/web/authorize/authCode");
        authCodeUrl.append("?scope=" + authCodeRequest.getScope());
        authCodeUrl.append("&state=" + authCodeRequest.getState());
        authCodeUrl.append("&appId=" + this.clientProfile.getAppId());
        authCodeUrl.append("&clientType=" + authCodeRequest.getClientType());
        authCodeUrl.append("&callbackUrl=" + this.clientProfile.getCallbackUrl());
        return authCodeUrl.toString();
    }

    private String createHttpsRequestHead(ClientProfile clientProfile) {
        StringBuffer stringBuffer = new StringBuffer("https://");
        stringBuffer.append(clientProfile.getIamIp());
        if (clientProfile.getIamPort() != 0) {
            stringBuffer.append(":" + clientProfile.getIamPort());
        }
        stringBuffer.append("/uas");
        return stringBuffer.toString();
    }

    @Override
    public TokenResponse getTokenByAuthCode(TokenRequest request) throws IAMRequestException {
        TokenResponse response = null;
        String url = this.createHttpsRequestHead(this.clientProfile) + "/api/v1/token";
        Map<String, String> params = this.constructAuthCodeParams(request);
        HttpClientResult<?> result = null;
        try {
            result = HttpClientUtils.doPost(url, params);
        }
        catch (Exception e) {
            throw new IAMRequestException(e.getMessage());
        }
        if (result.getCode() != 200) {
            throw new IAMRequestException();
        }
        IAMResult iamResult = (IAMResult)JSONObject.parseObject((String)((String)result.getContent()), IAMResult.class);
        if (!iamResult.isSuccess()) {
            ErrorInfo errorInfo = (ErrorInfo)JSONObject.toJavaObject((JSON)((JSON)iamResult.getInfo()), ErrorInfo.class);
            throw new IAMRequestException(errorInfo);
        }
        response = (TokenResponse)JSONObject.toJavaObject((JSON)((JSON)iamResult.getInfo()), TokenResponse.class);
        return response;
    }

    private Map<String, String> constructAuthCodeParams(TokenRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        String appId = this.clientProfile.getAppId();
        String secret = this.clientProfile.getSecret();
        params.put("grant_type", "authorization_code");
        params.put("code", request.getCode());
        params.put("appId", appId);
        params.put("secret", secret);
        params.put("nonce", request.getNonce());
        return params;
    }

    @Override
    public Object getUserInfo(String accessToken) throws IAMRequestException {
        JSONObject userInfo = null;
        String url = this.createHttpsRequestHead(this.clientProfile) + "/api/v1/token/personInfo";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("appId", this.clientProfile.getAppId());
        HttpClientResult<?> result = null;
        try {
            result = HttpClientUtils.doPost(url, params);
        }
        catch (Exception e) {
            throw new IAMRequestException(e.getMessage());
        }
        if (result.getCode() != 200) {
            throw new IAMRequestException();
        }
        IAMResult iamResult = (IAMResult)JSONObject.parseObject((String)((String)result.getContent()), IAMResult.class);
        if (!iamResult.isSuccess()) {
            ErrorInfo errorInfo = (ErrorInfo)JSONObject.toJavaObject((JSON)((JSON)iamResult.getInfo()), ErrorInfo.class);
            throw new IAMRequestException(errorInfo);
        }
        userInfo = (JSONObject)iamResult.getInfo();
        return userInfo;
    }

    @Override
    public void logOutToken(String refreshToken) throws IAMRequestException {
        String url = this.createHttpsRequestHead(this.clientProfile) + "/api/v1/token/revoke";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "revoke_token");
        params.put("refresh_token", refreshToken);
        params.put("appId", this.clientProfile.getAppId());
        HttpClientResult<?> result = null;
        try {
            result = HttpClientUtils.doPost(url, params);
        }
        catch (Exception e) {
            throw new IAMRequestException(e.getMessage());
        }
        if (result.getCode() != 200) {
            throw new IAMRequestException();
        }
        IAMResult iamResult = (IAMResult)JSONObject.parseObject((String)((String)result.getContent()), IAMResult.class);
        if (!iamResult.isSuccess()) {
            ErrorInfo errorInfo = (ErrorInfo)JSONObject.toJavaObject((JSON)((JSON)iamResult.getInfo()), ErrorInfo.class);
            throw new IAMRequestException(errorInfo);
        }
        LoggerUtil.info("revoke token from IAM success,refreshToken:{}\uff0cappId:{}", refreshToken, this.clientProfile.getAppId());
    }

    @Override
    public TokenResponse refreshToken(String refreshToken) throws IAMRequestException {
        TokenResponse response = null;
        String url = this.createHttpsRequestHead(this.clientProfile) + "/api/v1/token/refresh";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", refreshToken);
        params.put("appId", this.clientProfile.getAppId());
        HttpClientResult<?> result = null;
        try {
            result = HttpClientUtils.doPost(url, params);
        }
        catch (Exception e) {
            throw new IAMRequestException(e.getMessage());
        }
        if (result.getCode() != 200) {
            throw new IAMRequestException();
        }
        IAMResult iamResult = (IAMResult)JSONObject.parseObject((String)((String)result.getContent()), IAMResult.class);
        if (!iamResult.isSuccess()) {
            ErrorInfo errorInfo = (ErrorInfo)JSONObject.toJavaObject((JSON)((JSON)iamResult.getInfo()), ErrorInfo.class);
            throw new IAMRequestException(errorInfo);
        }
        response = (TokenResponse)JSONObject.toJavaObject((JSON)((JSON)iamResult.getInfo()), TokenResponse.class);
        return response;
    }

    private void checkClientProfile() {
        if (StringUtils.isEmpty((CharSequence)this.clientProfile.getIamIp()) || StringUtils.isEmpty((CharSequence)this.clientProfile.getAppId()) || StringUtils.isEmpty((CharSequence)this.clientProfile.getSecret())) {
            throw new ProfileInvalidException("iamIp or appId or secret is empty");
        }
    }
}

