/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.iam.logger;

import com.xdja.iam.logger.LogIdGen;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    private static final String LOG_HEADER = "[{}:{}] - [lid:{}][{}] ";

    public static Logger getLogger() {
        return LoggerFactory.getLogger(LoggerUtil.class);
    }

    private static String getCallerClassName() {
        return LoggerUtil.getCurrentStack().getClassName();
    }

    private static String getLogFlag() {
        StackTraceElement callerStack = LoggerUtil.getCurrentStack();
        String callerSimpleClassName = callerStack.getFileName().replace(".java", "");
        String callerMethodName = callerStack.getMethodName();
        return callerSimpleClassName + "." + callerMethodName;
    }

    private static StackTraceElement getCurrentStack() {
        StackTraceElement[] callerStacks = Thread.currentThread().getStackTrace();
        for (int i = 1; i < callerStacks.length; ++i) {
            if (callerStacks[i].getClassName().equals(LoggerUtil.class.getName())) continue;
            return callerStacks[i];
        }
        return callerStacks[1];
    }

    private static String generateFormatTemplate(String msg) {
        return LOG_HEADER + msg;
    }

    private static Object[] generateFormatArguments(Object ... arguments) {
        StackTraceElement traceElement = LoggerUtil.getCurrentStack();
        Object[] logArguments = new Object[]{traceElement.getFileName(), traceElement.getLineNumber(), LogIdGen.currentLogIndex(), LoggerUtil.getLogFlag()};
        return ArrayUtils.addAll((Object[])logArguments, (Object[])arguments);
    }

    public static void warn(String format, Object ... arguments) {
        LoggerUtil.getLogger().warn(LoggerUtil.generateFormatTemplate(format), LoggerUtil.generateFormatArguments(arguments));
    }

    public static void info(String format, Object ... arguments) {
        LoggerUtil.getLogger().info(LoggerUtil.generateFormatTemplate(format), LoggerUtil.generateFormatArguments(arguments));
    }

    public static void debug(String format, Object ... arguments) {
        LoggerUtil.getLogger().debug(LoggerUtil.generateFormatTemplate(format), LoggerUtil.generateFormatArguments(arguments));
    }

    public static void error(String format, Object ... arguments) {
        LoggerUtil.getLogger().error(LoggerUtil.generateFormatTemplate(format), LoggerUtil.generateFormatArguments(arguments));
    }
}

