/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.iam.tool;

import com.alibaba.fastjson.JSONObject;
import com.xdja.iam.model.HttpClientResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static final String ENCODING = "UTF-8";
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int SOCKET_TIMEOUT = 6000;
    private static SSLConnectionSocketFactory sslsf = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static org.apache.http.ssl.SSLContextBuilder builder = null;

    public static CloseableHttpClient getHttpClient() throws Exception {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        });
        HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean idempotent;
                if (executionCount >= 5) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(120000).setSocketTimeout(120000).build();
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setRetryHandler(myRetryHandler).setDefaultRequestConfig(requestConfig).build();
        return httpclient;
    }

    public static HttpClientResult<?> doGet(String url, int resultType) throws Exception {
        return HttpClientUtils.doGet(url, null, null, null, resultType);
    }

    public static HttpClientResult<?> doGet(String url, Map<String, String> urlParams, int resultType) throws Exception {
        return HttpClientUtils.doGet(url, null, urlParams, null, resultType);
    }

    public static HttpClientResult<?> doGet(String url, Map<String, String> headers, Map<String, String> urlParams, int resultType) throws Exception {
        return HttpClientUtils.doGet(url, headers, urlParams, null, resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult<?> doGet(String url, Map<String, String> headers, Map<String, String> params, Map<String, String> pathParams, int resultType) throws Exception {
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        url = HttpClientUtils.replaceUrlPathParams(url, pathParams);
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpGet.setConfig(requestConfig);
        HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpGet);
        CloseableHttpResponse httpResponse = null;
        try {
            switch (resultType) {
                case 1: {
                    HttpClientResult<String> httpClientResult = HttpClientUtils.getStringResult(httpResponse, httpClient, (HttpRequestBase)httpGet);
                    return httpClientResult;
                }
                case 3: {
                    HttpClientResult<InputStream> httpClientResult = HttpClientUtils.getInputStreamResult(httpResponse, httpClient, (HttpRequestBase)httpGet);
                    return httpClientResult;
                }
                case 2: {
                    HttpClientResult<byte[]> httpClientResult = HttpClientUtils.getByteArrayResult(httpResponse, httpClient, (HttpRequestBase)httpGet);
                    return httpClientResult;
                }
            }
            HttpClientResult<String> httpClientResult = HttpClientUtils.getStringResult(httpResponse, httpClient, (HttpRequestBase)httpGet);
            return httpClientResult;
        }
        finally {
            HttpClientUtils.release(httpResponse, httpClient);
        }
    }

    private static String replaceUrlPathParams(String url, Map<String, String> pathParams) {
        String result = url;
        if (pathParams != null) {
            Set<Map.Entry<String, String>> entrySet = pathParams.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                result = url.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            return result;
        }
        return result;
    }

    public static HttpClientResult<?> doPost(String url) throws Exception {
        return HttpClientUtils.doPost(url, null, null, null, null);
    }

    public static HttpClientResult<?> doPost(String url, Map<String, String> params) throws Exception {
        return HttpClientUtils.doPost(url, null, null, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult<?> doPost(String url, Map<String, String> headers, Map<String, String> bodyParams, Map<String, String> urlParams, Map<String, String> pathParams) throws Exception {
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpPost.setConfig(requestConfig);
        HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPost);
        HttpClientUtils.packageParam(urlParams, (HttpEntityEnclosingRequestBase)httpPost);
        HttpClientUtils.packageBody(bodyParams, httpPost);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult<String> httpClientResult = HttpClientUtils.getStringResult(httpResponse, httpClient, (HttpRequestBase)httpPost);
            return httpClientResult;
        }
        finally {
            HttpClientUtils.release(httpResponse, httpClient);
        }
    }

    public static HttpClientResult<?> doPut(String url) throws Exception {
        return HttpClientUtils.doPut(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult<?> doPut(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        HttpPut httpPut = new HttpPut(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpPut.setConfig(requestConfig);
        HttpClientUtils.packageParam(params, (HttpEntityEnclosingRequestBase)httpPut);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult<String> httpClientResult = HttpClientUtils.getStringResult(httpResponse, httpClient, (HttpRequestBase)httpPut);
            return httpClientResult;
        }
        finally {
            HttpClientUtils.release(httpResponse, httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult<?> doDelete(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpDelete.setConfig(requestConfig);
        CloseableHttpResponse httpResponse = null;
        try {
            HttpClientResult<String> httpClientResult = HttpClientUtils.getStringResult(httpResponse, httpClient, (HttpRequestBase)httpDelete);
            return httpClientResult;
        }
        finally {
            HttpClientUtils.release(httpResponse, httpClient);
        }
    }

    public static HttpClientResult<?> doDelete(String url, Map<String, String> params) throws Exception {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("_method", "delete");
        return HttpClientUtils.doPost(url, params);
    }

    public static void packageHeader(Map<String, String> params, HttpRequestBase httpMethod) {
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, ENCODING));
        }
    }

    private static void packageBody(Map<String, String> bodyParams, HttpPost httpPost) {
        if (bodyParams != null) {
            StringEntity entity = new StringEntity(JSONObject.toJSONString(bodyParams), ContentType.create((String)"application/json", (String)ENCODING));
            httpPost.setEntity((HttpEntity)entity);
        }
    }

    public static HttpClientResult<String> getStringResult(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
        if (httpResponse != null && httpResponse.getStatusLine() != null) {
            String content = "";
            if (httpResponse.getEntity() != null) {
                content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)ENCODING);
            }
            return new HttpClientResult<String>(httpResponse.getStatusLine().getStatusCode(), content);
        }
        return new HttpClientResult<String>(500);
    }

    public static HttpClientResult<byte[]> getByteArrayResult(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
        if (httpResponse != null && httpResponse.getStatusLine() != null) {
            byte[] content = null;
            if (httpResponse.getEntity() != null) {
                content = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
            }
            return new HttpClientResult<byte[]>(httpResponse.getStatusLine().getStatusCode(), content);
        }
        return new HttpClientResult<byte[]>(500);
    }

    public static HttpClientResult<InputStream> getInputStreamResult(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
        if (httpResponse != null && httpResponse.getStatusLine() != null) {
            InputStream content = null;
            if (httpResponse.getEntity() != null) {
                content = httpResponse.getEntity().getContent();
            }
            return new HttpClientResult<InputStream>(httpResponse.getStatusLine().getStatusCode(), content);
        }
        return new HttpClientResult<InputStream>(500);
    }

    public static void release(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient) throws IOException {
        if (httpResponse != null) {
            httpResponse.close();
        }
        if (httpClient != null) {
            httpClient.close();
        }
    }
}

