/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.identifiers.grantidentifiers;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.xdja.identifiers.grantidentifiers.PermissionActivity;
import com.xdja.identifiers.library.IIdentifierListener;
import com.xdja.identifiers.library.IdentiferBean;
import com.xdja.identifiers.library.IdentifiersType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;

class IdentiferGrantHelper {
    private static IdentiferGrantHelper singleton;
    private static final Uri GRANT_IDENTIFER_URI;
    private static final String METHOD_IDENTIFIER = "methodIdentifier";
    private static final String IDENTIFIER_LISTENER_BUNDLE = "identifier_listener_bundle";
    private static final String IDENTIFIER_TYPE_BUNDLE = "identifier_type_bundle";
    private static final String IDENTIFIER_BUNDLE = "identifier_bundle";
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IdentiferGrantHelper with(Context context) {
        if (singleton != null) return singleton;
        Class<IdentiferGrantHelper> clazz = IdentiferGrantHelper.class;
        synchronized (IdentiferGrantHelper.class) {
            if (singleton != null) return singleton;
            singleton = new IdentiferGrantHelper(context);
            Intent mIntent = new Intent();
            mIntent.setComponent(new ComponentName("com.xdja.Identifiers.example", "com.xdja.Identifiers.example.UpdateService"));
            if (Build.VERSION.SDK_INT >= 26) {
                context.startForegroundService(mIntent);
            } else {
                context.startService(mIntent);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private IdentiferGrantHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public void grantIdentifer(@NonNull IIdentifierListener.Stub identifierListener, IdentifiersType type) throws IllegalArgumentException {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                Intent mIntent = new Intent(this.context, PermissionActivity.class);
                Bundle bundle = new Bundle();
                bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, identifierListener.asBinder());
                mIntent.putExtra(IDENTIFIER_BUNDLE, bundle);
                mIntent.setFlags(0x10000000);
                this.context.startActivity(mIntent);
            } else {
                String imei = null;
                try {
                    imei = this.getImei();
                    if (!TextUtils.isEmpty((CharSequence)imei)) {
                        identifierListener.getIndetifier(new IdentiferBean(1, "", imei));
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (TextUtils.isEmpty((CharSequence)imei) && Build.VERSION.SDK_INT >= 29) {
                    if (type == null) {
                        type = IdentifiersType.ANDROID_ID;
                    }
                    Bundle bundle = new Bundle();
                    bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, identifierListener.asBinder());
                    bundle.putInt(IDENTIFIER_TYPE_BUNDLE, type.ordinal());
                    this.context.getContentResolver().call(GRANT_IDENTIFER_URI, METHOD_IDENTIFIER, null, bundle);
                } else {
                    try {
                        identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", imei));
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            String imei = this.getImei();
            try {
                if (!TextUtils.isEmpty((CharSequence)imei)) {
                    identifierListener.getIndetifier(new IdentiferBean(1, "", imei));
                } else {
                    identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", imei));
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @NonNull
    public IdentiferBean grantIdentiferSync(IdentifiersType type) throws IllegalArgumentException {
        final IdentifierBeanWrapper wrapper = new IdentifierBeanWrapper();
        if (Build.VERSION.SDK_INT >= 23) {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                return new IdentiferBean(6, "\u65e0\u8bfb\u53d6\u8bbe\u5907\u6807\u8bc6\u6743\u9650", "");
            }
            String imei = null;
            try {
                imei = this.getImei();
                if (!TextUtils.isEmpty((CharSequence)imei)) {
                    return new IdentiferBean(1, "", imei);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)imei) && Build.VERSION.SDK_INT >= 29) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                IIdentifierListener.Stub stub = new IIdentifierListener.Stub(){

                    @Override
                    public void getIndetifier(IdentiferBean indentifier) throws RemoteException {
                        wrapper.identiferBean = indentifier;
                        countDownLatch.countDown();
                    }
                };
                if (type == null) {
                    type = IdentifiersType.ANDROID_ID;
                }
                Bundle bundle = new Bundle();
                bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, stub.asBinder());
                bundle.putInt(IDENTIFIER_TYPE_BUNDLE, type.ordinal());
                this.context.getContentResolver().call(GRANT_IDENTIFER_URI, METHOD_IDENTIFIER, null, bundle);
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return wrapper.identiferBean;
            }
            return new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", "");
        }
        String imei = this.getImei();
        if (!TextUtils.isEmpty((CharSequence)imei)) {
            return new IdentiferBean(1, "", imei);
        }
        return new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", "");
    }

    @SuppressLint(value={"MissingPermission"})
    private String getImei() {
        String imei = "";
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 19) {
            Class<?> clazz = telephonyManager.getClass();
            try {
                Method getImei = clazz.getDeclaredMethod("getImei", new Class[0]);
                imei = (String)getImei.invoke((Object)telephonyManager, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                imei = "";
            }
        }
        if (TextUtils.isEmpty((CharSequence)imei) && telephonyManager != null) {
            imei = telephonyManager.getDeviceId();
        }
        return imei;
    }

    static {
        GRANT_IDENTIFER_URI = Uri.parse((String)"content://com.xdja.identifiers.provider");
    }

    static class IdentifierBeanWrapper {
        IdentiferBean identiferBean;

        IdentifierBeanWrapper() {
        }
    }
}

