/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.identifiers.grantidentifiers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.xdja.identifiers.grantidentifiers.PermissionActivity;
import com.xdja.identifiers.library.DeviceUtils;
import com.xdja.identifiers.library.IIdentifierListener;
import com.xdja.identifiers.library.IdentiferBean;
import com.xdja.identifiers.library.IdentifiersType;
import java.util.concurrent.CountDownLatch;

class IdentifierGrantHelper {
    private static IdentifierGrantHelper singleton;
    private static final Uri GRANT_IDENTIFER_URI;
    private static final String METHOD_IDENTIFIER = "methodIdentifier";
    private static final String IDENTIFIER_LISTENER_BUNDLE = "identifier_listener_bundle";
    private static final String IDENTIFIER_TYPE_BUNDLE = "identifier_type_bundle";
    private static final String IDENTIFIER_BUNDLE = "identifier_bundle";
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IdentifierGrantHelper with(Context context) {
        if (singleton != null) return singleton;
        Class<IdentifierGrantHelper> clazz = IdentifierGrantHelper.class;
        synchronized (IdentifierGrantHelper.class) {
            if (singleton != null) return singleton;
            singleton = new IdentifierGrantHelper(context);
            Intent mIntent = new Intent();
            mIntent.setComponent(new ComponentName("com.xdja.Identifiers.example", "com.xdja.Identifiers.example.UpdateService"));
            if (Build.VERSION.SDK_INT >= 26) {
                context.startForegroundService(mIntent);
            } else {
                context.startService(mIntent);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private IdentifierGrantHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public void grantIdentifer(IIdentifierListener.Stub identifierListener, IdentifiersType type) throws IllegalArgumentException {
        if (identifierListener == null) {
            throw new IllegalArgumentException("\u56de\u8c03\u63a5\u53e3\u4e3a\u7a7a");
        }
        if (type == null || IdentifiersType.IMEI == type) {
            if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                Intent mIntent = new Intent(this.context, PermissionActivity.class);
                Bundle bundle = new Bundle();
                bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, identifierListener.asBinder());
                mIntent.putExtra(IDENTIFIER_BUNDLE, bundle);
                mIntent.setFlags(0x10000000);
                this.context.startActivity(mIntent);
                return;
            }
            String imei = DeviceUtils.getDeviceIMEI(this.context);
            try {
                if (!TextUtils.isEmpty((CharSequence)imei)) {
                    identifierListener.getIndetifier(new IdentiferBean(1, "", imei));
                    return;
                }
                if (IdentifiersType.IMEI == type) {
                    identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", imei));
                    return;
                }
                type = IdentifiersType.ANDROID_ID;
                Bundle bundle = new Bundle();
                bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, identifierListener.asBinder());
                bundle.putInt(IDENTIFIER_TYPE_BUNDLE, type.ordinal());
                this.context.getContentResolver().call(GRANT_IDENTIFER_URI, METHOD_IDENTIFIER, null, bundle);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", imei));
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        } else {
            try {
                Bundle bundle = new Bundle();
                bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, identifierListener.asBinder());
                bundle.putInt(IDENTIFIER_TYPE_BUNDLE, type.ordinal());
                this.context.getContentResolver().call(GRANT_IDENTIFER_URI, METHOD_IDENTIFIER, null, bundle);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", ""));
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    public IdentiferBean grantIdentiferSync(IdentifiersType type) throws IllegalArgumentException {
        if (type == null || type == IdentifiersType.IMEI) {
            if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                return new IdentiferBean(6, "\u65e0\u8bfb\u53d6\u8bbe\u5907\u6807\u8bc6\u6743\u9650", "");
            }
            String imei = DeviceUtils.getDeviceIMEI(this.context);
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                return new IdentiferBean(1, "", imei);
            }
            if (type == IdentifiersType.IMEI) {
                return new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", "");
            }
        }
        final IdentifierBeanWrapper wrapper = new IdentifierBeanWrapper();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        IIdentifierListener.Stub stub = new IIdentifierListener.Stub(){

            @Override
            public void getIndetifier(IdentiferBean indentifier) throws RemoteException {
                wrapper.identiferBean = indentifier;
                countDownLatch.countDown();
            }
        };
        if (type == null) {
            type = IdentifiersType.ANDROID_ID;
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, stub.asBinder());
            bundle.putInt(IDENTIFIER_TYPE_BUNDLE, type.ordinal());
            this.context.getContentResolver().call(GRANT_IDENTIFER_URI, METHOD_IDENTIFIER, null, bundle);
            countDownLatch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", "");
        }
        return wrapper.identiferBean;
    }

    static {
        GRANT_IDENTIFER_URI = Uri.parse((String)"content://com.xdja.identifiers.provider");
    }

    static class IdentifierBeanWrapper {
        IdentiferBean identiferBean;

        IdentifierBeanWrapper() {
        }
    }
}

