/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.identifiers.grantidentifiers;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.xdja.identifiers.grantidentifiers.R;
import com.xdja.identifiers.library.DeviceUtils;
import com.xdja.identifiers.library.IIdentifierListener;
import com.xdja.identifiers.library.IdentiferBean;
import com.xdja.identifiers.library.IdentifiersType;

public class PermissionActivity
extends AppCompatActivity {
    private static final int PERMISSION_CODE = 1;
    private static final Uri GRANT_IDENTIFIER_URI = Uri.parse((String)"content://com.xdja.identifiers.provider");
    private static final String METHOD_IDENTIFIER = "methodIdentifier";
    private static final String IDENTIFIER_LISTENER_BUNDLE = "identifier_listener_bundle";
    private static final String IDENTIFIER_BUNDLE = "identifier_bundle";
    private static final String IDENTIFIER_TYPE_BUNDLE = "identifier_type_bundle";
    private IIdentifierListener identifierListener;
    private int identifierType;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_permission);
        this.identifierType = this.getIntent().getIntExtra(IDENTIFIER_TYPE_BUNDLE, -1);
        this.identifierListener = IIdentifierListener.Stub.asInterface(this.getIntent().getBundleExtra(IDENTIFIER_BUNDLE).getBinder(IDENTIFIER_LISTENER_BUNDLE));
        ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_PHONE_STATE"}, (int)1);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != 1) {
            this.backRequestPermissionsResult(requestCode, permissions, grantResults);
            return;
        }
        if (!"android.permission.READ_PHONE_STATE".equals(permissions[0]) || grantResults[0] != 0) {
            try {
                this.identifierListener.getIndetifier(new IdentiferBean(6, "\u65e0\u8bfb\u53d6\u8bbe\u5907\u6807\u8bc6\u6743\u9650", ""));
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.backRequestPermissionsResult(requestCode, permissions, grantResults);
            return;
        }
        String imei = DeviceUtils.getDeviceIMEI((Context)this);
        try {
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                this.identifierListener.getIndetifier(new IdentiferBean(1, "", imei));
                this.backRequestPermissionsResult(requestCode, permissions, grantResults);
                return;
            }
            if (this.identifierType == IdentifiersType.IMEI.ordinal()) {
                this.identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", ""));
                this.backRequestPermissionsResult(requestCode, permissions, grantResults);
                return;
            }
            if (this.identifierType == -1) {
                this.identifierType = IdentifiersType.ANDROID_ID.ordinal();
            }
            Bundle bundle = new Bundle();
            bundle.putBinder(IDENTIFIER_LISTENER_BUNDLE, this.identifierListener.asBinder());
            bundle.putInt(IDENTIFIER_TYPE_BUNDLE, this.identifierType);
            this.getContentResolver().call(GRANT_IDENTIFIER_URI, METHOD_IDENTIFIER, null, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.identifierListener.getIndetifier(new IdentiferBean(8, "\u672a\u77e5\u9519\u8bef", ""));
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        this.backRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void backRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.finish();
    }
}

