/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.identifiers.library;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.identifiers.library.GAMdmPolicy;
import java.lang.reflect.Method;

public class DeviceUtils {
    public static final String LOG_TAG = DeviceUtils.class.getSimpleName();
    private static String deviceIMEI = "";

    public static String getDeviceIMEI(Context context) {
        if (TextUtils.isEmpty((CharSequence)deviceIMEI)) {
            deviceIMEI = GAMdmPolicy.getImeiByDevicePolicyManager();
            Log.w((String)LOG_TAG, (String)("getImeiByDevicePolicyManager\uff1a" + deviceIMEI));
            if (TextUtils.isEmpty((CharSequence)deviceIMEI)) {
                deviceIMEI = DeviceUtils.getIMEIByAndroidApi(context);
                Log.w((String)LOG_TAG, (String)("getIMEIByAndroidApi\uff1a" + deviceIMEI));
            }
            if (!TextUtils.isEmpty((CharSequence)deviceIMEI)) {
                String[] identitySplit = deviceIMEI.split("/");
                deviceIMEI = identitySplit[0];
            }
        }
        Log.d((String)LOG_TAG, (String)("deviceIMEI\uff1a" + deviceIMEI));
        return deviceIMEI;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getIMEIByAndroidApi(Context context) {
        String imei = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                imei = telephonyManager.getImei();
            } else {
                Class<?> clazz = telephonyManager.getClass();
                Method getImei = clazz.getDeclaredMethod("getImei", new Class[0]);
                imei = (String)getImei.invoke((Object)telephonyManager, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            imei = "";
        }
        return imei;
    }
}

