/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.idgenclient.start;

import com.xdja.idgenclient.common.DefaultValues;
import com.xdja.idgenclient.common.ReturnValues;
import com.xdja.idgenclient.start.IdGenService;
import com.xdja.rpcstubpool.RpcClientInfo;
import com.xdja.rpcstubpool.RpcStubIdGenFactory;
import com.xdja.rpcstubpool.RpcStubPool;
import com.xdja.rpcstubpool.RpcStubPoolConfig;
import com.xdja.thrift.datatype.ResLong;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDGClient {
    private static Logger logger = LoggerFactory.getLogger(IDGClient.class);
    private RpcStubIdGenFactory rpcfactory = null;
    private RpcStubPool<RpcClientInfo<IdGenService.Client>> rpcstubpool = null;
    private RpcStubPoolConfig config = new RpcStubPoolConfig();
    private int timeout = 2000;
    private int serverMode = 3;
    private String sHost = "";
    private int sPort = -1;
    public static AtomicLong logIndex = new AtomicLong(0L);

    public IDGClient(String serverHost, int serverPort) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.config.setMaxActive(100);
        this.config.setMaxIdle(100);
        this.config.setMaxWait(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    public IDGClient(String serverHost, int serverPort, int serverMode, RpcStubPoolConfig config, int timeout) {
        this.timeout = timeout;
        this.config = config;
        this.serverMode = serverMode;
        this.sHost = serverHost;
        this.sPort = serverPort;
    }

    public boolean init() {
        String logFlag = "IDGClient.init";
        logger.info("<lid:{}>[{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{logIndex.getAndDecrement(), logFlag, this.sHost, this.sPort, this.serverMode});
        this.rpcfactory = new RpcStubIdGenFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcstubpool = new RpcStubPool();
        if (!this.rpcstubpool.init(logIndex.get(), this.config, (PoolableObjectFactory<RpcClientInfo<IdGenService.Client>>)this.rpcfactory)) {
            logger.warn("<lid:{}> rpcpool init failed!", (Object)logIndex);
            return false;
        }
        return true;
    }

    public RpcClientInfo<IdGenService.Client> getServiceClient(long logIndex) {
        String logFlag = "IDGClient.getServiceClient";
        RpcClientInfo<IdGenService.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcstubpool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("<lid:{}>[{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcstubpool.returnBrokenResource(logIndex, rpcconnect);
            return null;
        }
    }

    public long getId(String msgType, String ext) {
        String logFlag = "IDGClient.getId";
        logger.info("<lid:{}>[{}] msgType:{}", new Object[]{logIndex, logFlag, msgType});
        RpcClientInfo<IdGenService.Client> ci = null;
        try {
            ci = this.getServiceClient(logIndex.getAndDecrement());
            if (ci == null) {
                logger.warn("<lid:{}>[{}] id:{} cann't get IDGS Client", (Object)logIndex, (Object)logFlag);
                return DefaultValues.ID_ERROR;
            }
            ResLong res = ci.getClient().getId(logIndex.get(), logFlag, msgType, ext);
            if (res.res == ReturnValues.SUCCESS) {
                logger.info("<lid:{}>[{}] id:{}", new Object[]{logIndex, logFlag, res.value});
            } else {
                logger.warn("<lid:{}>[{}] cann't get id, result:{}", new Object[]{logIndex, logFlag, res.res});
            }
            this.rpcstubpool.returnResource(logIndex.get(), ci);
            return res.value;
        }
        catch (TException e) {
            logger.warn("<lid:{}>[{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcstubpool.returnBrokenResource(logIndex.get(), ci);
            return DefaultValues.ID_ERROR;
        }
    }

    public void shutDown() {
        String logFlag = "IDGClient.shutDown";
        if (this.rpcstubpool == null) {
            return;
        }
        try {
            this.rpcstubpool.destroy(logIndex.getAndDecrement());
            this.rpcstubpool = null;
        }
        catch (Exception ex) {
            logger.error("<lid:{}>[{}]exception happened while shutting down rpcstubpool...", (Object)logIndex.get(), (Object)logFlag);
        }
    }
}

