/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rpcstubpool;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStubPool<T> {
    protected GenericObjectPool<T> internalPool;
    public AtomicInteger logId = new AtomicInteger(-1);
    public static AtomicInteger iNum = new AtomicInteger(0);
    private static Logger logger = LoggerFactory.getLogger(RpcStubPool.class);
    private AtomicBoolean isInit = new AtomicBoolean(false);

    private boolean isInit() {
        return this.isInit.get();
    }

    private String getClassName() {
        return "RpcStubPool";
    }

    public boolean init(long logIndex, GenericObjectPool.Config poolConfig, PoolableObjectFactory<T> factory) {
        this.isInit.set(true);
        String logFlag = String.valueOf(this.getClassName()) + ".init";
        if (this.internalPool != null) {
            try {
                this.destroy(logIndex);
            }
            catch (Exception e) {
                logger.warn("<lid:{}>[{}]resource is null! Exception detail:{}", new Object[]{logIndex, logFlag, e});
                return false;
            }
        }
        this.internalPool = new GenericObjectPool(factory, poolConfig);
        return this.internalPool != null;
    }

    public void destroy(long logIndex) {
        String logFlag = String.valueOf(this.getClassName()) + ".destroy";
        if (!this.isInit()) {
            logger.warn("<lid:{}>[{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return;
        }
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            logger.warn("<lid:{}>[{}]destory failed! Exception detail:{}", new Object[]{logIndex, logFlag, e});
        }
    }

    public T getResource(long logIndex) {
        String logFlag = String.valueOf(this.getClassName()) + ".getResource";
        if (!this.isInit()) {
            logger.warn("<lid:{}>[{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return null;
        }
        Object res = null;
        try {
            res = this.internalPool.borrowObject();
            return (T)res;
        }
        catch (Exception e) {
            logger.warn("<lid:{}>[{}]Could not get a resource from the pool! Exception detail:{}", new Object[]{logIndex, logFlag, e});
            this.returnBrokenResource(logIndex, res);
            return null;
        }
    }

    public void returnBrokenResource(long logIndex, T resource) {
        String logFlag = String.valueOf(this.getClassName()) + ".returnBrokenResource";
        if (!this.isInit()) {
            logger.warn("<lid:{}>[{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return;
        }
        if (resource == null) {
            logger.warn("<lid:{}>[{}]resource is null!", (Object)logIndex, (Object)logFlag);
            return;
        }
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            logger.warn("<lid:{}>[{}]invalidateObject failed!  Exception detail:{}", new Object[]{logIndex, logFlag, e});
        }
    }

    public void returnResource(long logIndex, T resource) {
        String logFlag = String.valueOf(this.getClassName()) + ".returnResource";
        if (!this.isInit()) {
            logger.warn("<lid:{}>[{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return;
        }
        if (resource == null) {
            logger.warn("<lid:{}>[{}]resource is null!", (Object)logIndex, (Object)logFlag);
            return;
        }
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            logger.warn("<lid:{}>[{}]returnObject failed!  Exception detail:{}", new Object[]{logIndex, logFlag, e});
        }
    }
}

