/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley;

import com.xdja.imsdk.volley.Network;
import com.xdja.imsdk.volley.NetworkDispatcher;
import com.xdja.imsdk.volley.Request;
import com.xdja.imsdk.volley.VolleyLog;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private AtomicInteger mSequenceGenerator = new AtomicInteger();
    private final Set<Request<?>> mCurrentRequests = new HashSet();
    private final PriorityBlockingQueue<Request<?>> mNetworkQueue = new PriorityBlockingQueue();
    private static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    private final Network mNetwork;
    private NetworkDispatcher[] mDispatchers;

    public RequestQueue(Network network) {
        this.mNetwork = network;
        this.mDispatchers = new NetworkDispatcher[4];
    }

    public RequestQueue(Network network, int threadPollSize) {
        if (threadPollSize <= 0) {
            threadPollSize = 4;
        }
        this.mNetwork = network;
        this.mDispatchers = new NetworkDispatcher[threadPollSize];
    }

    public void start() {
        this.stop();
        int i = 0;
        while (i < this.mDispatchers.length) {
            NetworkDispatcher networkDispatcher;
            this.mDispatchers[i] = networkDispatcher = new NetworkDispatcher(this.mNetworkQueue, this.mNetwork);
            networkDispatcher.start();
            ++i;
        }
    }

    public void stop() {
        int i = 0;
        while (i < this.mDispatchers.length) {
            if (this.mDispatchers[i] != null) {
                this.mDispatchers[i].quit();
            }
            ++i;
        }
    }

    public void resume() {
        int i = 0;
        while (i < this.mDispatchers.length) {
            if (this.mDispatchers[i] != null) {
                this.mDispatchers[i].resumeTask();
            }
            ++i;
        }
    }

    public void pause() {
        int i = 0;
        while (i < this.mDispatchers.length) {
            if (this.mDispatchers[i] != null) {
                this.mDispatchers[i].pauseTask();
            }
            ++i;
        }
    }

    public int getThreadPoolSize() {
        return this.mDispatchers.length;
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            try {
                Iterator<Request<?>> iterator = this.mCurrentRequests.iterator();
                while (iterator.hasNext()) {
                    Request<?> request = iterator.next();
                    if (request == null) continue;
                    request.cancel();
                    iterator.remove();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isExist(Object tag, String url) {
        for (Request<?> request : this.mCurrentRequests) {
            if (tag == null || url == null || !tag.equals(request.getTag()) || !url.equals(request.getUrl())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(RequestFilter filter) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            try {
                for (Request<?> request : this.mCurrentRequests) {
                    if (!filter.apply(request)) continue;
                    VolleyLog.d("cancel request:" + request.getUrl() + ", Tag:" + request.getTag(), new Object[0]);
                    request.cancel();
                    request.deliverCanceled();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancelAll(final Object tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Cannot cancelAll with a null tag");
        }
        VolleyLog.d("Cancels request in this queue with the given tag " + tag, new Object[0]);
        this.cancelAll(new RequestFilter(){

            @Override
            public boolean apply(Request<?> request) {
                if (tag instanceof String) {
                    return tag.equals(request.getTag());
                }
                return request.getTag() == tag;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Request<T> add(Request<T> request) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            if (this.isExist(request.getTag(), request.getUrl())) {
                VolleyLog.d("Request exist in Queue. tag:" + request.getTag() + ", url:" + request.getUrl(), new Object[0]);
                return request;
            }
            request.setRequestQueue(this);
            this.mCurrentRequests.add(request);
            VolleyLog.d("Add a Request to the current request queue " + this.mCurrentRequests.size(), new Object[0]);
        }
        request.setSequence(this.getSequenceNumber());
        request.addMarker("add-to-queue");
        this.mNetworkQueue.add(request);
        VolleyLog.d("Add a Request to the dispatch queue " + this.mNetworkQueue.size(), new Object[0]);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void finish(Request<T> request) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.remove(request);
        }
        VolleyLog.d("Remove a Request from the current queue " + this.mCurrentRequests.size(), new Object[0]);
    }

    public static interface RequestFilter {
        public boolean apply(Request<?> var1);
    }
}

