/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.network;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.utils.CachePath;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class OkHttpsClientMe
extends OkHttpClient {
    private static final String DISK_CACHE_NAME = "http-cache";
    private static final long DISK_CACHE_SIZE = 0x3200000L;
    public static final int TIME_OUT_UNIT = 30000;
    private static final String DEFAULT_PASSWORD = "111111";
    public static final String HEAD_TICKET = "ticket";
    private Context context;
    private UserCache userCache;
    private String password;
    private boolean isVerifyHostName = false;

    @Inject
    public OkHttpsClientMe(@Scoped(value="application") @NonNull Context context, UserCache userCache) {
        this(context, userCache, DEFAULT_PASSWORD);
    }

    public OkHttpsClientMe(Context context, UserCache userCache, String pwd) {
        this.context = context;
        this.userCache = userCache;
        this.password = pwd;
    }

    public OkHttpClient.Builder createBuilder() {
        String dirBuilder = CachePath.getParentCachePath() + File.separator + DISK_CACHE_NAME;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30000L, TimeUnit.MILLISECONDS).readTimeout(30000L, TimeUnit.MILLISECONDS).writeTimeout(30000L, TimeUnit.MILLISECONDS).cache(new Cache(new File(dirBuilder), 0x3200000L)).sslSocketFactory(this.makeSSLSocketFactory()).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return !OkHttpsClientMe.this.isVerifyHostName;
            }
        }).addInterceptor((Interceptor)new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                LogUtil.d(message);
            }
        }).setLevel(HttpLoggingInterceptor.Level.BODY));
        return builder;
    }

    private SSLSocketFactory makeSSLSocketFactory() {
        SSLContext sslContext = this.getSSLContext(this.readKeyStore(R.raw.truststore, this.context));
        if (sslContext == null) {
            return null;
        }
        return sslContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private KeyStore readKeyStore(@RawRes int res, @NonNull Context context) {
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inputStream = context.getResources().openRawResource(res);
            keyStore.load(inputStream, this.password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return keyStore;
    }

    @Nullable
    private SSLContext getSSLContext(@Nullable KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.password.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        return sslContext;
    }
}

