/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.proxy;

import android.text.TextUtils;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountType;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.notify.NotificationBean;
import com.xdja.im.core.proxy.IMUiKitProxy;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class IMUiKitProxyImpl
implements IMUiKitProxy {
    private AccountCallback accountCallback;
    private NotificationCallback notificationCallback;
    private UnReadMessageCallback unReadMessageCallback;

    private IMUiKitProxyImpl() {
    }

    public static IMUiKitProxyImpl getInstance() {
        return SingletonInstance.mInstance;
    }

    public void releaseProxy() {
        this.accountCallback = null;
        this.notificationCallback = null;
        this.unReadMessageCallback = null;
    }

    @Override
    public void setAccountCallback(AccountCallback callback) {
        this.accountCallback = callback;
    }

    @Override
    public void setNotificationCallback(NotificationCallback callback) {
        this.notificationCallback = callback;
    }

    @Override
    public void setUnReadMessageCallback(UnReadMessageCallback callback) {
        this.unReadMessageCallback = callback;
    }

    @Override
    public void getAccount(String account, final int type, Subscriber<AccountBean> subscriber) {
        Observable.just((Object)account).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<AccountBean>>(){

            public Observable<AccountBean> call(String account) {
                String sessionFlag = ToolUtils.getSessionTag(account, type);
                AccountBean accountBean = (AccountBean)DataCache.getInstance().get(sessionFlag);
                if (accountBean != null) {
                    return Observable.just((Object)accountBean);
                }
                if (IMUiKitProxyImpl.this.accountCallback == null) {
                    return Observable.error((Throwable)new IllegalArgumentException("Not register callback."));
                }
                AccountType accountType = type == 1 ? AccountType.TYPE_P2P : AccountType.TYPE_P2G;
                accountBean = IMUiKitProxyImpl.this.accountCallback.getAccount(account, accountType);
                if (accountBean == null) {
                    return Observable.error((Throwable)new IllegalArgumentException("Get account failed."));
                }
                DataCache.getInstance().put(sessionFlag, accountBean);
                return Observable.just((Object)accountBean);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void notifyAccountChanged(String account, AccountAction action) {
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("ERROR: notify account changed, but account is empty.");
            return;
        }
        LogUtil.d("Notify account Changed account " + account + "(" + (Object)((Object)action) + ")");
        String sFlag = ToolUtils.getSessionTag(account, 1);
        String gFlag = ToolUtils.getSessionTag(account, 2);
        switch (action) {
            case ACTION_UPDATE: {
                DataCache.getInstance().remove(sFlag);
                BusProvider.getInstance().post(new IMProxySessionEvent.RefreshSessionListEvent());
                break;
            }
            case ACTION_DELETE: {
                DataCache.getInstance().remove(sFlag);
                IMProxySessionEvent.DeleteSessionEvent deleteSessionEvent = new IMProxySessionEvent.DeleteSessionEvent();
                TalkSessionBean talkSessionBean = new TalkSessionBean();
                talkSessionBean.setTalkerAccount(account);
                talkSessionBean.setTalkType(1);
                deleteSessionEvent.setSessionBean(talkSessionBean);
                BusProvider.getInstance().post(deleteSessionEvent);
                break;
            }
            case ACTION_GROUP_REFRESH: {
                DataCache.getInstance().remove(gFlag);
                IMContactEvent.RefreshGroupEvent refreshGroupEvent = new IMContactEvent.RefreshGroupEvent();
                refreshGroupEvent.setAccount(account);
                BusProvider.getInstance().post(refreshGroupEvent);
                break;
            }
            case ACTION_GROUP_DISSOLUTION: {
                DataCache.getInstance().remove(gFlag);
                IMContactEvent.DissolutionGroupEvent dissolutionGroupEvent = new IMContactEvent.DissolutionGroupEvent();
                dissolutionGroupEvent.setAccount(account);
                BusProvider.getInstance().post(dissolutionGroupEvent);
            }
        }
    }

    @Override
    public boolean notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb) {
        if (this.notificationCallback == null) {
            LogUtil.d("Notify callback is null.");
            return false;
        }
        NotificationBean notificationBean = new NotificationBean();
        notificationBean.setAccount(sessionBean.getTalkerAccount());
        TalkMessageBean talkMessageBean = sessionBean.getLastMsg();
        String content = talkMessageBean.getContent();
        switch (talkMessageBean.getMessageType()) {
            case 1: {
                content = CommonTool.getString(R.string.im_uikit_voice);
                break;
            }
            case 3: {
                content = CommonTool.getString(R.string.im_uikit_image);
                break;
            }
            case 2: {
                content = CommonTool.getString(R.string.im_uikit_video);
                break;
            }
            case 4: {
                content = CommonTool.getString(R.string.im_uikit_file);
            }
        }
        notificationBean.setContent(content);
        notificationBean.setDisturb(isDisturb);
        notificationBean.setShowTime(sessionBean.getLastTime());
        LogUtil.d("Start to notify..." + notificationBean.toString());
        this.notificationCallback.notify(notificationBean);
        return true;
    }

    @Override
    public void updateUnReadMessageCount(int count) {
        if (this.unReadMessageCallback == null) {
            LogUtil.d("UnReadMessage callback is null.");
            return;
        }
        LogUtil.d("Update unRead message " + count);
        this.unReadMessageCallback.onRefresh(count);
    }

    private static class SingletonInstance {
        private static final IMUiKitProxyImpl mInstance = new IMUiKitProxyImpl();

        private SingletonInstance() {
        }
    }
}

