/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;
import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.uikit.ImUiKit;

public class MediaManager {
    private static final int VERSION = Build.VERSION.SDK_INT;
    private final AudioManager mAudioManager;
    private PowerManager.WakeLock mWakeLock;
    private boolean isWakeAcquire = false;
    private boolean isReceiverMode = false;
    private boolean isHeadsetOn = false;

    public boolean isReceiverMode() {
        return this.isReceiverMode;
    }

    public void setReceiverMode(boolean receiverMode) {
        this.isReceiverMode = receiverMode;
    }

    @SuppressLint(value={"InlinedApi"})
    private MediaManager() {
        Context context = ImUiKit.getInstance().getContext();
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        if (VERSION >= 21) {
            PowerManager pManager = (PowerManager)ImUiKit.getInstance().getContext().getSystemService("power");
            this.mWakeLock = pManager.newWakeLock(32, "MediaManager");
        }
    }

    public static MediaManager getInstance() {
        return SingletonInstance.mInstance;
    }

    public void onSensorChanged(boolean isReceiverMode) {
        if (!AudioPlayerManager.getInstance().isPlaying()) {
            if (this.isWakeAcquire) {
                this.wakeLockBrightRelease();
            }
            return;
        }
        if (isReceiverMode) {
            this.setReceiverModeOn();
        } else {
            this.setReceiverModeOff();
        }
    }

    public void setHeadsetOn(boolean headsetOn) {
        this.isHeadsetOn = headsetOn;
    }

    public boolean isHeadsetOn() {
        return this.isHeadsetOn || this.mAudioManager.isWiredHeadsetOn();
    }

    public void restoreAudioMode() {
        if (!TelphoneState.getPhotoStateIsIdle(ImUiKit.getInstance().getContext())) {
            return;
        }
        this.mAudioManager.setMode(0);
    }

    public void setReceiverModeOn() {
        this.mAudioManager.setMode(3);
    }

    public void setReceiverModeOff() {
        this.mAudioManager.setMode(0);
    }

    public void wakeLockBrightAcquire() {
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.isWakeAcquire = true;
            this.mWakeLock.setReferenceCounted(false);
            this.mWakeLock.acquire();
        }
    }

    public void wakeLockBrightRelease() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public boolean isWakeAcquire() {
        return this.isWakeAcquire;
    }

    private static class SingletonInstance {
        private static final MediaManager mInstance = new MediaManager();

        private SingletonInstance() {
        }
    }
}

