/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.widget;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.Chronometer;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.audio.manager.AudioManager;
import com.xdja.im.lib.audio.manager.DialogManager;
import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.lib.video.utils.AudioFunctions;
import com.xdja.im.uikit.R;
import java.lang.ref.WeakReference;

public class AudioRecorderButton
extends Button {
    private static final int STATE_NORMAL = 1;
    private static final int STATE_RECORDING = 2;
    private static final int STATE_WANT_TO_CANCEL = 3;
    private static final int LAST_TEN_SECOND_TO_CANCEL = 4;
    private int mCurrentState = 1;
    private final DialogManager mDialogManager;
    private final AudioManager mAudioManager;
    private boolean isRecording = false;
    private float mTime;
    private boolean mReady;
    private static final int DISTANCE_Y_CANCEL = 50;
    private static final int MSG_AUDIO_PREPARED = 272;
    private static final int MSG_DIALOG_DIMISS = 274;
    private final String dirPath;
    private static String lastTenSecordstr;
    private final Context mContext;
    private TimerHandler timeHandler = new TimerHandler(new WeakReference<AudioRecorderButton>(this));
    private MyHandler mHandler = new MyHandler(new WeakReference<AudioRecorderButton>(this));
    private final Runnable mGetVoiceLevelRunnable = new Runnable(){

        @Override
        public void run() {
            long beginTime = System.currentTimeMillis();
            while (AudioRecorderButton.this.isRecording) {
                try {
                    Thread.sleep(100L);
                    AudioRecorderButton.this.mTime = (float)(System.currentTimeMillis() - beginTime) / 1000.0f;
                    AudioRecorderButton.this.setImage(AudioRecorderButton.this.mAudioManager.getAmplitude());
                    if (!AudioRecorderButton.this.isRecording || !(AudioRecorderButton.this.mTime >= 50.0f)) continue;
                    AudioRecorderButton.this.timeHandler.sendEmptyMessage(60 - (int)AudioRecorderButton.this.mTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    AudioRecorderButton.this.reset();
                }
            }
        }
    };
    private AudioFinishRecorderListener audioFinishRecorderListener;

    public AudioRecorderButton(Context context) {
        this(context, null);
    }

    public AudioRecorderButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mDialogManager = new DialogManager(context);
        this.dirPath = FilePathUtils.getVoicePath();
        this.mAudioManager = new AudioManager(context, this.dirPath);
        this.mAudioManager.setOnAudioStateListener(new AudioManager.AudioStateListener(){

            @Override
            public void wellPrepared() {
                AudioRecorderButton.this.mHandler.sendEmptyMessage(272);
            }

            @Override
            public void checkCurrentFocusView() {
                AudioRecorderButton.this.changeState(1);
                AudioRecorderButton.this.mDialogManager.tooShortToShow(AudioRecorderButton.this.getContext());
            }

            @Override
            public void prepareFailed(int exceptionType) {
                AudioRecorderButton.this.changeState(1);
                if (exceptionType == ((AudioRecorderButton)AudioRecorderButton.this).mAudioManager.EXCEPTION) {
                    AudioRecorderButton.this.mDialogManager.getAudioPermissionErrToShow(AudioRecorderButton.this.getContext());
                } else if (exceptionType == ((AudioRecorderButton)AudioRecorderButton.this).mAudioManager.ILLEGALSTATE_EXCEPTION) {
                    AudioRecorderButton.this.mDialogManager.getAudioDeviceErrToShow(AudioRecorderButton.this.getContext());
                }
            }
        });
        this.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (!TelphoneState.getPhotoStateIsIdle(AudioRecorderButton.this.mContext)) {
                    CommonTool.showToast(R.string.im_uikit_phone_is_inCall);
                    return true;
                }
                AudioPlayerManager.getInstance().stopPlay();
                AudioRecorderButton.this.requestPermission();
                return true;
            }
        });
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CommonTool.showToast(R.string.im_uikit_record_too_short);
            }
        });
    }

    private void requestPermission() {
        if (PermissionUtils.hasSelfPermissions(this.mContext, "android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            new AudioAsyncTask().execute(new Void[0]);
        } else {
            PermissionUtils.requestPermissions((Activity)this.mContext, new String[]{"android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 3);
            if (!PermissionUtils.shouldShowRequestPermissionRationale((Activity)this.mContext, "android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                CommonTool.showToast(R.string.im_uikit_audio_deny);
            }
        }
    }

    public void setActivity(Activity activity) {
        this.mAudioManager.setActivity(activity);
    }

    private void startToRecording() {
        this.isRecording = true;
        this.mDialogManager.showRecordingDialog();
        this.mDialogManager.mVoiceChronometer.setBase(SystemClock.elapsedRealtime());
        this.mDialogManager.mVoiceChronometer.start();
        this.mDialogManager.mVoiceChronometer.setOnChronometerTickListener(new Chronometer.OnChronometerTickListener(){

            public void onChronometerTick(Chronometer chronometer) {
            }
        });
        Thread voiceThread = new Thread(this.mGetVoiceLevelRunnable);
        voiceThread.start();
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (action) {
            case 0: {
                this.changeState(2);
                break;
            }
            case 2: {
                if (!this.isRecording) break;
                if (this.wantToCancle(x, y)) {
                    this.changeState(3);
                    break;
                }
                this.changeState(2);
                break;
            }
            case 1: 
            case 3: {
                AudioFunctions.muteAudioFocus(false);
                if (!this.mReady) {
                    this.reset();
                    if (this.mDialogManager.isShowing()) {
                        this.mDialogManager.dismissDialog();
                        this.mAudioManager.cancel();
                    }
                    return super.onTouchEvent(event);
                }
                if (!this.isRecording || this.mTime < 0.6f) {
                    this.mDialogManager.tooShort(this.getContext());
                    this.mAudioManager.cancel();
                    this.mHandler.sendEmptyMessageDelayed(274, 10L);
                } else if (this.mCurrentState == 2 || this.mTime >= 60.0f) {
                    this.mDialogManager.dismissDialog();
                    this.mAudioManager.release();
                    if (this.audioFinishRecorderListener != null) {
                        this.audioFinishRecorderListener.onFinish(this.mTime, this.mAudioManager.getCurrentFilePath());
                    }
                } else if (this.mCurrentState == 3) {
                    this.mDialogManager.dismissDialog();
                    this.mAudioManager.cancel();
                }
                this.reset();
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private void reset() {
        this.isRecording = false;
        this.mTime = 0.0f;
        this.mReady = false;
        this.changeState(1);
    }

    private boolean wantToCancle(int x, int y) {
        if (x < 0 || x > this.getWidth()) {
            return true;
        }
        return y < -50 || y > this.getHeight() + 50;
    }

    private void changeState(int state) {
        if (this.mCurrentState != state) {
            this.mCurrentState = state;
            switch (state) {
                case 1: {
                    this.setText(R.string.im_uikit_start_record);
                    break;
                }
                case 2: {
                    this.setText(R.string.im_uikit_stop_record);
                    if (!this.isRecording) break;
                    this.mDialogManager.recording();
                    break;
                }
                case 3: {
                    this.setText(R.string.im_uikit_cancel_send);
                    this.mDialogManager.wantToCancel();
                    break;
                }
                case 4: {
                    this.mDialogManager.lastTenSeconds(lastTenSecordstr);
                    break;
                }
            }
        }
    }

    private void setImage(double voiceValue) {
        if (voiceValue < 600.0) {
            int voiceImageID = 1;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 600.0 && voiceValue < 1000.0) {
            int voiceImageID = 1;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 1000.0 && voiceValue < 1200.0) {
            int voiceImageID = 1;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 1200.0 && voiceValue < 1400.0) {
            int voiceImageID = 2;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 1400.0 && voiceValue < 1600.0) {
            int voiceImageID = 2;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 1600.0 && voiceValue < 1800.0) {
            int voiceImageID = 2;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 1800.0 && voiceValue < 2000.0) {
            int voiceImageID = 3;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 2000.0 && voiceValue < 3000.0) {
            int voiceImageID = 3;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 3000.0 && voiceValue < 4000.0) {
            int voiceImageID = 4;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 4000.0 && voiceValue < 6000.0) {
            int voiceImageID = 5;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 6000.0 && voiceValue < 8000.0) {
            int voiceImageID = 6;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 8000.0 && voiceValue < 10000.0) {
            int voiceImageID = 6;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 10000.0 && voiceValue < 12000.0) {
            int voiceImageID = 6;
            this.mHandler.sendEmptyMessage(voiceImageID);
        } else if (voiceValue > 12000.0) {
            int voiceImageID = 7;
            this.mHandler.sendEmptyMessage(voiceImageID);
        }
    }

    public void setAudioFinishRecorderListener(AudioFinishRecorderListener listener) {
        this.audioFinishRecorderListener = listener;
    }

    private class AudioAsyncTask
    extends AsyncTask<Void, Void, Boolean> {
        private AudioAsyncTask() {
        }

        protected Boolean doInBackground(Void ... params) {
            AudioFunctions.muteAudioFocus(true);
            AudioRecorderButton.this.mReady = true;
            AudioRecorderButton.this.mAudioManager.prepareAudio();
            return true;
        }
    }

    public static interface AudioFinishRecorderListener {
        public void onFinish(float var1, String var2);
    }

    private static class MyHandler
    extends Handler {
        private final WeakReference<AudioRecorderButton> mActivity;

        public MyHandler(WeakReference<AudioRecorderButton> mActivity) {
            this.mActivity = mActivity;
        }

        public void handleMessage(Message msg) {
            if (this.mActivity.get() != null) {
                switch (msg.what) {
                    case 272: {
                        AudioFunctions.muteAudioFocus(true);
                        ((AudioRecorderButton)((Object)this.mActivity.get())).startToRecording();
                        break;
                    }
                    case 274: {
                        ((AudioRecorderButton)((Object)this.mActivity.get())).mDialogManager.dismissDialog();
                        break;
                    }
                    default: {
                        ((AudioRecorderButton)((Object)this.mActivity.get())).mDialogManager.updateVoiceLevel(msg.what);
                    }
                }
                super.handleMessage(msg);
            }
        }
    }

    private static class TimerHandler
    extends Handler {
        private final WeakReference<AudioRecorderButton> mActivity;

        public TimerHandler(WeakReference<AudioRecorderButton> mActivity) {
            this.mActivity = mActivity;
        }

        public void handleMessage(Message msg) {
            if (this.mActivity.get() != null) {
                lastTenSecordstr = String.format(CommonTool.getString(R.string.im_uikit_also_have), msg.what);
                switch (msg.what) {
                    case 0: {
                        MotionEvent motionEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)10.0f, (float)10.0f, (int)0);
                        ((AudioRecorderButton)((Object)this.mActivity.get())).dispatchTouchEvent(motionEvent);
                        break;
                    }
                    default: {
                        ((AudioRecorderButton)((AudioRecorderButton)((Object)this.mActivity.get()))).mDialogManager.mLabel.setText((CharSequence)lastTenSecordstr);
                    }
                }
            }
        }
    }
}

