/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.emoji.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmotionUtils {
    private static Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");

    public static SpannableString formatSpanContent(CharSequence sourceContent, Context context, float smallScall) {
        SpannableString spannableString = new SpannableString((CharSequence)"");
        try {
            spannableString = new SpannableString(sourceContent);
            Matcher matcher = pattern.matcher(sourceContent);
            while (matcher.find()) {
                String emoStr = matcher.group(1);
                emoStr = emoStr.substring(1, emoStr.length() - 1);
                ImageCache imageCache = ImageCache.getInstance();
                Bitmap bitmap = null;
                if (smallScall == 0.7f) {
                    if (imageCache.smallCashGet(emoStr) != null) {
                        bitmap = imageCache.smallCashGet(emoStr);
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName("sticker/emotion/" + emoStr + ".png", context.getResources());
                        bitmap = BitmapUtils.small(bitmap, smallScall);
                        imageCache.smallCashPut(emoStr, bitmap);
                    }
                } else if (smallScall == 1.1f) {
                    if (imageCache.get(emoStr) != null) {
                        bitmap = imageCache.get(emoStr);
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName("sticker/emotion/" + emoStr + ".png", context.getResources());
                        bitmap = BitmapUtils.small(bitmap, smallScall);
                        imageCache.put(emoStr, bitmap);
                    }
                }
                ImageSpan span = new ImageSpan(context, bitmap);
                spannableString.setSpan((Object)span, matcher.start(), matcher.end(), 33);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spannableString;
    }

    public static SpannableString formatSpanByIndex(Context context, int facesPos, float smallScall) {
        String srcName = "emoji_" + String.format("%03d", facesPos) + ".png";
        try {
            Bitmap bitmap = BitmapUtils.getBitmapWithName("sticker/emotion/" + srcName, context.getResources());
            bitmap = BitmapUtils.small(bitmap, smallScall);
            ImageSpan is = new ImageSpan(context, bitmap);
            String cs = "[emoji_" + String.format("%03d", facesPos) + "]";
            SpannableString ss = new SpannableString((CharSequence)cs);
            ss.setSpan((Object)is, 0, cs.length(), 33);
            return ss;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return new SpannableString((CharSequence)("[" + srcName + "]"));
    }

    public static boolean mathEmotion(String content) {
        Matcher matcher = pattern.matcher(content);
        return matcher.find();
    }
}

