/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.base.frame.view.ActivitySuperBaseView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.lib.video.manager.VideoManager;
import com.xdja.im.lib.video.ui.presenter.VideoRecorderPresenter;
import com.xdja.im.lib.video.ui.view.vu.VideoRecorderVu;
import com.xdja.im.lib.video.utils.DisplayUtils;
import com.xdja.im.lib.video.utils.UnitUtil;
import com.xdja.im.lib.video.widget.CustomView;
import com.xdja.im.lib.video.widget.FocusView;
import com.xdja.im.lib.video.widget.SendView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewVideoRecorder
extends ActivitySuperBaseView<VideoRecorderPresenter>
implements VideoRecorderVu,
VideoManager.IVideoRecordCallback,
View.OnClickListener,
View.OnTouchListener {
    private VideoManager mVideoManager;
    private CustomView progressBar;
    private int mProgress;
    private TextView videoRecordTime;
    private TextView mBtnRecord;
    private SendView send;
    private RelativeLayout recordLayout;
    private RelativeLayout toolBars;
    private boolean isCompleteRecord;
    private boolean isSending;
    private Handler handler;
    private SurfaceView mSurfaceView;
    private FocusView mFocusView;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_video_receoder;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (view != null) {
            this.initView(view);
        }
    }

    private void initView(View view) {
        this.handler = new ViewRecordHandler();
        this.mSurfaceView = (SurfaceView)view.findViewById(R.id.main_surface_view);
        this.toolBars = (RelativeLayout)view.findViewById(R.id.layout_video_tools);
        TextView bottomBarBack = (TextView)view.findViewById(R.id.bottombar_back_recorder);
        this.send = (SendView)view.findViewById(R.id.view_send);
        this.send.backLayout.setOnClickListener((View.OnClickListener)this);
        this.send.selectLayout.setOnClickListener((View.OnClickListener)this);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)bottomBarBack.getLayoutParams();
        params.height = DisplayUtils.getBottomStatusHeight((Context)this.getActivity());
        bottomBarBack.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mBtnRecord = (TextView)view.findViewById(R.id.btn_recorder);
        this.mBtnRecord.setOnTouchListener((View.OnTouchListener)this);
        TextView btnTransCamera = (TextView)view.findViewById(R.id.btn_trans);
        btnTransCamera.setOnClickListener((View.OnClickListener)this);
        this.videoRecordTime = (TextView)view.findViewById(R.id.video_record_time);
        TextView btnClose = (TextView)view.findViewById(R.id.btn_close);
        btnClose.setOnClickListener((View.OnClickListener)this);
        this.recordLayout = (RelativeLayout)view.findViewById(R.id.layout_recorder);
        this.progressBar = (CustomView)view.findViewById(R.id.main_progress_bar);
        this.mVideoManager = new VideoManager(this.getActivity());
        this.mFocusView = (FocusView)view.findViewById(R.id.video_focusview);
    }

    @Override
    public void startPreview() {
        this.mSurfaceView.setVisibility(0);
        this.mVideoManager.setRecordCallback(this);
        this.mVideoManager.setSurfaceView(this.mSurfaceView);
    }

    private void startView() {
        if (this.progressBar.getVisibility() == 8) {
            this.videoRecordTime.setVisibility(0);
            this.toolBars.setVisibility(8);
            this.videoRecordTime.setVisibility(0);
            this.videoRecordTime.setText((CharSequence)"");
            this.progressBar.startAnim();
            this.mProgress = 0;
            this.progressBar.setVisibility(0);
            this.progressBar.startProgressBar();
        }
    }

    private void stopView(boolean isSave) {
        if (this.progressBar.getVisibility() == 0) {
            this.progressBar.stopAnim();
            this.handler.removeMessages(0);
            this.progressBar.stopProgressBar();
            this.progressBar.setVisibility(8);
            this.videoRecordTime.setVisibility(8);
            if (isSave) {
                this.mBtnRecord.setVisibility(8);
                this.send.startAnim(this.getContext());
            } else {
                this.toolBars.setVisibility(0);
            }
        }
    }

    @Override
    public void prepareRecord() {
        this.handler.removeMessages(0);
        this.handler.sendMessageDelayed(this.handler.obtainMessage(0), 1000L);
        this.isCompleteRecord = false;
    }

    @Override
    public void completeRecord() {
        this.isCompleteRecord = true;
    }

    @Override
    public void onPrepareFailed(int code, String msg) {
        LogUtil.e("ERROR: Recorder video failed. code " + code + ", msg " + msg);
        if (code == 0) {
            CommonTool.showToast(R.string.im_uikit_carame_error);
            this.getActivity().finish();
        } else {
            CommonTool.showToast(R.string.im_uikit_video_recorder_failed);
            this.cancelAndRerecord();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_rerecored) {
            this.cancelAndRerecord();
        } else if (id2 == R.id.btn_send) {
            this.isSending = true;
            this.mVideoManager.stopPlay(false);
            VideoItem videoItem = new VideoItem();
            videoItem.setFilePath(this.mVideoManager.getFirstFrameFile().getPath());
            videoItem.setFileName(this.mVideoManager.getFirstFrameFile().getName());
            videoItem.setFileSize(this.mVideoManager.getFirstFrameFile().length());
            videoItem.setSuffix(UnitUtil.getFileSuffix(this.mVideoManager.getFirstFrameFile().getPath()));
            videoItem.setRawFileName(this.mVideoManager.getVideoFile().getName());
            videoItem.setRawFilePath(this.mVideoManager.getVideoFile().getPath());
            videoItem.setRawFileSize(this.mVideoManager.getVideoFile().length());
            videoItem.setRawSuffix(".mp4");
            videoItem.setDuration(this.mProgress);
            ((VideoRecorderPresenter)this.getPresenter()).sendVideoMessage(videoItem);
        } else if (id2 == R.id.btn_close) {
            this.getActivity().finish();
        } else if (id2 == R.id.btn_trans) {
            this.mVideoManager.transformCamera();
        }
    }

    @Override
    public void cancelAndRerecord() {
        this.send.stopAnim(this.getContext());
        this.stopView(false);
        this.isCompleteRecord = false;
        this.recordLayout.setVisibility(0);
        this.toolBars.setVisibility(0);
        this.mBtnRecord.setVisibility(0);
        this.videoRecordTime.setVisibility(8);
        this.mFocusView.setVisibility(0);
        this.mVideoManager.deleteTargetFile();
        this.mVideoManager.stopPlay(true);
    }

    @Override
    public int onKeyBack() {
        if (this.isCompleteRecord) {
            this.cancelAndRerecord();
            return -1;
        }
        return 0;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        boolean ret = false;
        int action = event.getAction();
        if (v.getId() == R.id.btn_recorder) {
            switch (action) {
                case 0: {
                    this.startView();
                    this.mVideoManager.record();
                    ret = true;
                    break;
                }
                case 1: {
                    if (this.mVideoManager.isRecording() && this.mProgress < 2) {
                        this.mVideoManager.stopRecordUnSave();
                        this.showToast(R.string.im_uikit_video_record_timeshort);
                        this.stopView(false);
                        break;
                    }
                    this.mVideoManager.stopRecordSave();
                    this.stopView(true);
                    ret = false;
                    this.mFocusView.setVisibility(8);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isCompleteRecord() {
        return this.isCompleteRecord;
    }

    @Override
    public VideoManager getVideoManager() {
        return this.mVideoManager;
    }

    @Override
    public boolean isSending() {
        return this.isSending;
    }

    @SuppressLint(value={"HandlerLeak"})
    private class ViewRecordHandler
    extends Handler {
        private ViewRecordHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (!ViewVideoRecorder.this.mVideoManager.isRecording()) break;
                    ViewVideoRecorder.this.mProgress++;
                    ViewVideoRecorder.this.videoRecordTime.setText((CharSequence)UnitUtil.getVideoRecordDuration(ViewVideoRecorder.this.mProgress, ViewVideoRecorder.this.getContext()));
                    if (ViewVideoRecorder.this.mProgress > 10) {
                        ViewVideoRecorder.this.mProgress--;
                        ViewVideoRecorder.this.videoRecordTime.invalidate();
                        ViewVideoRecorder.this.mVideoManager.stopRecordSave();
                        ViewVideoRecorder.this.stopView(true);
                        break;
                    }
                    this.sendMessageDelayed(ViewVideoRecorder.this.handler.obtainMessage(0), 1000L);
                }
            }
        }
    }
}

