/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.hardware.Camera;
import java.util.List;

@SuppressLint(value={"Deprecation"})
public class CameraHelper {
    public static Camera.Size getOptimalVideoSize(List<Camera.Size> supportedVideoSizes, List<Camera.Size> previewSizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)w / (double)h;
        List<Camera.Size> videoSizes = previewSizes;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int betterWidth = 800;
        for (Camera.Size size : videoSizes) {
            double ratio = (double)size.height / (double)size.width;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.width - betterWidth) < minDiff) || !supportedVideoSizes.contains(size)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.width - betterWidth);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : videoSizes) {
                if (!((double)Math.abs(size.width - betterWidth) < minDiff) || !supportedVideoSizes.contains(size)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.width - betterWidth);
            }
        }
        return optimalSize;
    }

    public static int getDefaultBackFacingCameraInstance() {
        return CameraHelper.getDefaultCamera(0);
    }

    public static int getDefaultFrontFacingCameraInstance() {
        return CameraHelper.getDefaultCamera(1);
    }

    @TargetApi(value=9)
    private static int getDefaultCamera(int position) {
        int mNumberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < mNumberOfCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != position) continue;
            return i;
        }
        return 0;
    }

    public static void setCameraFocusMode(String focusMode, Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List sfm = parameters.getSupportedFocusModes();
        if (sfm.contains(focusMode)) {
            parameters.setFocusMode(focusMode);
        }
        camera.setParameters(parameters);
    }
}

