/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.utils;

import android.content.Context;
import com.xdja.im.uikit.R;
import java.text.DecimalFormat;

public class UnitUtil {
    public static String getFileSuffix(String filePath) {
        int index = filePath.lastIndexOf(".");
        return filePath.substring(index);
    }

    public static String getVideoRecordDuration(int duration, Context context) {
        return duration + context.getResources().getString(R.string.im_uikit_video_record_unit);
    }

    public static String getVideoDuration(int duration) {
        if (duration >= 10) {
            return "00:" + duration;
        }
        return "00:0" + duration;
    }

    public static String getVideoFileSize(long size) {
        String fileSizeString;
        DecimalFormat df = new DecimalFormat("#.0");
        DecimalFormat df1 = new DecimalFormat("#");
        DecimalFormat df2 = new DecimalFormat("#.00");
        String wrongSize = "0B";
        if (size == 0L) {
            return wrongSize;
        }
        if (size < 1024L) {
            fileSizeString = df1.format((int)size) + "B";
            if (fileSizeString.contains(".") && fileSizeString.contains(".")) {
                String[] s = fileSizeString.split("\\.");
                fileSizeString = s[0] + "B";
            }
        } else {
            fileSizeString = size < 0x100000L ? (size > 1024000L ? "1MB" : ((int)size / 1024 < 100 ? df.format((int)size / 1024) + "KB" : df1.format((int)size / 1024) + "KB")) : (size < 0x40000000L ? ((double)size / 1048576.0 >= 10.0 ? df.format((double)size / 1048576.0) + "MB" : df2.format((double)size / 1048576.0) + "MB") : df.format((double)size / 1.073741824E9) + "GB");
        }
        return fileSizeString;
    }
}

