/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.im.base.di.component.ApplicationComponent;
import com.xdja.im.base.di.component.DaggerApplicationComponent;
import com.xdja.im.base.di.component.DaggerRepositoryComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.module.ApplicationModule;
import com.xdja.im.base.di.module.CacheModule;
import com.xdja.im.base.di.module.DataStoreModule;
import com.xdja.im.base.di.module.RepositoryModule;
import com.xdja.im.common.cache.entity.CardEntity;
import com.xdja.im.common.cache.entity.UserEntity;
import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.imageloader.GlideImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.message.TalkCustomBean;
import com.xdja.im.core.model.message.TalkNotifyBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMModuleProxyImpl;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.push.PushControllerImp;
import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.uikit.IClient;
import com.xdja.im.uikit.UiKitOptions;
import com.xdja.im.uikit.UiKitParams;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ImUiKit
implements IClient {
    private static Context sContext;
    private ApplicationComponent applicationComponent;
    private RepositoryComponent repositoryComponent;
    private ImageLoader mImageLoader;
    private UiKitOptions sdkOptions;
    private UiKitParams sdkParams;
    private String curAccount;

    private ImUiKit() {
    }

    public static ImUiKit getInstance() {
        return SingletonInstance.mInstance;
    }

    @Override
    public void init(Context context, @Nullable UiKitOptions options) {
        LogUtil.init(true, "ImUiKit");
        LogUtil.d("ImUiKit Init.");
        sContext = context.getApplicationContext();
        this.sdkOptions = options;
        this.initComponent();
        this.initImagePicker();
    }

    @Override
    public void login(@NonNull UiKitParams params) {
        LogUtil.d("ImUiKit login.");
        if (params == null || params.getAccountBean() == null || TextUtils.isEmpty((CharSequence)params.getAccountBean().getAccount())) {
            LogUtil.e("Init user account is null error!");
            return;
        }
        this.sdkParams = params;
        this.initData();
        this.initPushClient();
        this.initIMProxy();
        this.initDatabases();
    }

    @Override
    public void logout(int flag) {
        LogUtil.d("ImUiKit logout.");
        DatabaseManager.getInstance().close();
        IMModuleProxyImpl.getInstance().releaseProxy();
        IMUiKitProxyImpl.getInstance().releaseProxy();
        if (flag == 1) {
            PushControllerImp.getInstance().releasePush();
        }
    }

    @Override
    public void init(Context context, @NonNull UiKitParams params, @Nullable UiKitOptions options) {
        LogUtil.init(true, "ImUiKit");
        LogUtil.d("ImUiKit Init.");
        if (params == null || params.getAccountBean() == null || TextUtils.isEmpty((CharSequence)params.getAccountBean().getAccount())) {
            LogUtil.e("Init user account is null error!");
            return;
        }
        sContext = context.getApplicationContext();
        this.sdkOptions = options;
        this.sdkParams = params;
        this.curAccount = params.getAccountBean().getAccount();
        LogUtil.d("params:" + params.toString());
        this.initComponent();
        this.initData();
        this.initPushClient();
        this.initIMProxy();
        this.initDatabases();
        this.initImagePicker();
    }

    @Override
    public void release(int flag) {
        LogUtil.d("ImUiKit release.");
        DatabaseManager.getInstance().close();
        IMModuleProxyImpl.getInstance().releaseProxy();
        IMUiKitProxyImpl.getInstance().releaseProxy();
        if (flag == 1) {
            PushControllerImp.getInstance().releasePush();
        }
    }

    @Override
    public UiKitOptions getOptions() {
        return this.sdkOptions;
    }

    @Override
    public void sendNotifyTextMessage(String sessionId, int sessionType, TalkNotifyBean bean) {
        IMModuleProxyImpl.getInstance().sendNotifyMessage(sessionId, sessionType, bean);
    }

    @Override
    public void sendCustomTextMessage(String sessionId, int sessionType, TalkCustomBean bean) {
        IMModuleProxyImpl.getInstance().sendCustomMessage(sessionId, sessionType, bean);
    }

    @Override
    public void clearSessionData(String sessionId, int sessionType) {
        IMModuleProxyImpl.getInstance().clearSessionData(sessionId, sessionType);
    }

    @Override
    public void clearAllSessionData() {
        IMModuleProxyImpl.getInstance().clearAllSessionData();
    }

    @Override
    public void clearAllCacheData() {
        IMModuleProxyImpl.getInstance().clearCacheData();
    }

    @Override
    public void setReceiveMode(String sessionId, int sessionType, boolean isOpen) {
        IMModuleProxyImpl.getInstance().setReceiveMode(sessionId, sessionType, isOpen);
    }

    @Override
    public void setNoDisturbMode(String sessionId, int sessionType, boolean isDisturb) {
        IMModuleProxyImpl.getInstance().setNoDisturbMode(sessionId, sessionType, isDisturb);
    }

    @Override
    public void setSessionTop(String sessionId, int sessionType, boolean isTop) {
        IMModuleProxyImpl.getInstance().setSessionTop(sessionId, sessionType, isTop);
    }

    @Override
    public SessionParam getSessionParam(String sessionId, int sessionType) {
        return IMModuleProxyImpl.getInstance().getSessionParam(sessionId, sessionType);
    }

    @Override
    public void notifyAccountChanged(String account, AccountAction action) {
        IMUiKitProxyImpl.getInstance().notifyAccountChanged(account, action);
    }

    @Override
    public void registerAccountCallback(AccountCallback callback) {
        IMUiKitProxyImpl.getInstance().setAccountCallback(callback);
    }

    @Override
    public void registerNotificationCallback(NotificationCallback callback) {
        IMUiKitProxyImpl.getInstance().setNotificationCallback(callback);
    }

    @Override
    public void registerUnReadMessageCallback(UnReadMessageCallback callback) {
        IMUiKitProxyImpl.getInstance().setUnReadMessageCallback(callback);
    }

    private void initComponent() {
        this.applicationComponent = DaggerApplicationComponent.builder().applicationModule(new ApplicationModule()).cacheModule(new CacheModule()).build();
        this.repositoryComponent = DaggerRepositoryComponent.builder().applicationComponent(this.applicationComponent).dataStoreModule(new DataStoreModule()).repositoryModule(new RepositoryModule()).build();
    }

    private void initData() {
        String account = this.sdkParams.getAccountBean().getAccount();
        String clientId = this.sdkParams.getClientId();
        String ticket = "01edbce2bfca663294c99a3f8f6e497c";
        UserEntity userEntity = new UserEntity();
        userEntity.setAccount(account);
        userEntity.setTicket(ticket);
        userEntity.setClientId(clientId);
        this.repositoryComponent.accountCache().put(userEntity);
        CardEntity cardEntity = new CardEntity();
        int index = clientId.lastIndexOf("/") + 1;
        cardEntity.setCardId(clientId.substring(index));
        this.repositoryComponent.cardCache().put(cardEntity);
        NotificationUtil.getInstance().setLoginAccount(account);
        LogUtil.d("sdkParams:" + this.sdkParams.toString());
    }

    private void initPushClient() {
        PushControllerImp.getInstance().startPush(this.sdkParams.getClientId());
    }

    private void initIMProxy() {
        IMModuleProxyImpl.getInstance().initIMProxy();
    }

    private void initDatabases() {
        String account = this.sdkParams.getAccountBean().getAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("ERROR: Init account is null error.");
            return;
        }
        DatabaseManager.getInstance().initDatabase(sContext, account);
    }

    private void initImagePicker() {
        ImagePickerConfig config = new ImagePickerConfig();
        config.setColumnNum(3);
        config.setMaxSize(0x1E00000L);
        config.setMaxSelectNum(9);
        config.setMode(2);
        config.setType(0);
        ImagePickerManager.getInstance().setConfig(config);
        this.mImageLoader = new GlideImageLoader();
        ImagePickerManager.getInstance().setImageLoader(this.mImageLoader);
        CameraManager.getInstance().setImageLoader(this.mImageLoader);
    }

    public ImageLoader getImageLoader() {
        return this.mImageLoader;
    }

    public RepositoryComponent getComponent() {
        return this.repositoryComponent;
    }

    public Context getContext() {
        return sContext;
    }

    public UiKitOptions getSdkOptions() {
        return this.sdkOptions;
    }

    public String getCurAccount() {
        return this.curAccount;
    }

    public void setCurAccount(String curAccount) {
        this.curAccount = curAccount;
    }

    private static class SingletonInstance {
        private static final ImUiKit mInstance = new ImUiKit();

        private SingletonInstance() {
        }
    }
}

